//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_TextEngine_h)
#define Candera_TextEngine_h

#include <Candera/Environment.h>

#define Candera_TextEngine_Include

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/TextCoordinate.h>
#include <Candera/TextEngine/TextRect.h>
#include <Candera/TextEngine/TextSize.h>

#include <Candera/TextEngine/Font.h>
#include <Candera/TextEngine/FontEngine.h>
#include <Candera/TextEngine/FontStore.h>
#include <Candera/TextEngine/Metrics.h>
#include <Candera/TextEngine/Style.h>

#include <Candera/TextEngine/TextRenderer.h>

#include <Candera/TextEngine/TextRenderContext.h>
#include <Candera/TextEngine/GlyphBitmap.h>
#include <Candera/TextEngine/GlyphCacheAccess.h>

#include <Candera/TextEngine/PreprocessingContext.h>
#include <Candera/TextEngine/MinimalPreprocessingContext.h>
#include <Candera/TextEngine/MaximalPreprocessingContext.h>

#include <Candera/TextEngine/TextMeasureContext.h>
#include <Candera/TextEngine/CursorTextMeasureContext.h>
#include <Candera/TextEngine/GlyphTextMeasureContext.h>

#include <Candera/TextEngine/LayoutingOptions.h>
#include <Candera/TextEngine/TextProperties.h>
#include <Candera/TextEngine/ShapingOptions.h>
#include <Candera/TextEngine/MeasuringOptions.h>

#include <Candera/TextEngine/TextEngineDataTypes.h>
#include <Candera/TextEngine/TextEngineMemoryPool.h>
#include <Candera/TextEngine/TextLayoutStrategy.h>

#undef Candera_TextEngine_Include

#endif// Candera_TextEngine_h
