//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PreprocessingContext.h"
#include <Candera/TextEngine/Style.h>

namespace Candera { namespace TextRendering {

PreprocessingContext::PreprocessingContext(const TextRenderContext* reference) :
    TextMeasureContext(reference),
    m_glyphOrder(OriginalGlyphOrder)
{
}

PreprocessingContext::Iterator PreprocessingContext::GetIterator() const
{
    return Iterator(GetReferenceIterator());
}

void PreprocessingContext::SetGlyphOrder(GlyphOrder glyphOrder)
{
    m_glyphOrder = glyphOrder;
}
PreprocessingContext::GlyphOrder PreprocessingContext::GetGlyphOrder() const
{
    return m_glyphOrder;
}

    }    // namespace TextRendering
}    // namespace Candera

