//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_Metrics_h)
#define Candera_Metrics_h

#include <Candera/TextEngine/Types.h>

namespace Candera {
    namespace TextRendering {

        /** @addtogroup CanderaTextEngine
         *  @{
         */

        /**
         *  @brief Metrics is a structure holding basic Font measurements.
         *  
         *  The ascender and descender are given staring from the base line,
         *  from bottom to top. Values over the base line are positive and 
         *  values under the base line are negative.
         *  Line height and max advance are always positive.
         */
        struct Metrics {
            Int16 ascender;     ///< Font ascender value in device pixels.
            Int16 descender;    ///< Font descender value in device pixels.
            Int16 lineHeight;   ///< Line height of the font (lineGap = lineHeight - (ascender - descender)).
            Int16 maxAdvance;   ///< Maximum vertical advance of a font character.
        };

        /** @} */ // end of CanderaTextEngine

    }// namespace TextRendering

}// namespace Candera


#endif// Candera_Metrics_h
