//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_MeasuringOptions_h)
#define Candera_MeasuringOptions_h

#include <Candera/TextEngine/Types.h>

namespace Candera {

    namespace TextRendering {

/** @addtogroup CanderaTextEngine
 *  @{
 */

        /** 
         *  @brief This class defines how the text is measured.
         */
        class MeasuringOptions {
            public:

                /**
                 *  Determine whether the measurement includes the final advance.
                 *  The advance is included according to text direction.
                 */
                enum FinalAdvance {
                    IncludeFinalAdvance,        ///< The measurement will contain the final advance.
                    ExcludeFinalAdvance,        ///< The measurement will not contain the final advance.
                    DefaultFinalAdvance = IncludeFinalAdvance   ///< Default is IncludeFinalAdvance
                };

                /**
                 *  Determine whether the measurement uses a fixed transversal size.
                 *  The transversal size is the measure in a direction orthogonal to the text direction.
                 */
                enum TransversalSize {
                    ConstantTransversalSize,     ///< The transversal size is retrieved from the font global metrics.
                    ActualTransversalSize,       ///< The transversal size is computed for the current text.
                    DefaultTransversalSize = ConstantTransversalSize ///< Default is ConstantTransversalSize
                };

                /**
                 *  Retrieve the final advance option.
                 *  @return See FinalAdvance.
                 */
                FinalAdvance GetFinalAdvance() const { return m_finalAdvance; }

                /**
                 *  Retrieve the transversal size option.
                 *  @return See TransversalSize.
                 */
                TransversalSize GetTransversalSize() const { return m_transversalSize; }

            private:
                FinalAdvance m_finalAdvance;
                TransversalSize m_transversalSize;
        };

 /** @} */ // end of CanderaTextEngine

    }    // namespace TextRendering

}    // namespace Candera

#endif    // Candera_MeasuringOptions_h
