//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MaximalPreprocessingContext.h"
#include <Candera/TextEngine/Style.h>
#include <Candera/TextEngine/TextRect.h>
#include <Candera/TextEngine/Internal/PreprocessingContextVectorIterator.h>

namespace Candera { namespace TextRendering {

FontIdentifier MaximalPreprocessingContext::MaximalGlyphData::GetFontIdentifier() const
{
    return m_fontIdentifier;
}
GlyphIndex MaximalPreprocessingContext::MaximalGlyphData::GetGlyphIndex() const
{
    return m_glyphIndex;
}
TextPosition MaximalPreprocessingContext::MaximalGlyphData::GetCharacterPosition() const
{
    return m_characterPosition;
}
PixelPosition2D MaximalPreprocessingContext::MaximalGlyphData::GetPosition() const
{
    return m_position;
}
PixelSize2D MaximalPreprocessingContext::MaximalGlyphData::GetAdvance() const
{
    return m_advance;
}
TextRect MaximalPreprocessingContext::MaximalGlyphData::GetRect() const
{
    return m_rect;
}
GlyphBitmap::Direction MaximalPreprocessingContext::MaximalGlyphData::GetDirection() const
{
    return m_direction;
}


MaximalPreprocessingContext::MaximalPreprocessingContext(const TextRenderContext* reference) :
    PreprocessingContext(reference),
    m_container()
{
}

MaximalPreprocessingContext::MaximalGlyphDataIterator MaximalPreprocessingContext::GetMaximalGlyphDataIterator() const
{
    return MaximalGlyphDataIterator(m_container.ConstBegin(), m_container.ConstEnd());
}

void MaximalPreprocessingContext::Reserve(SizeType size)
{
    static_cast<void>(m_container.Reserve(size));
}

void MaximalPreprocessingContext::Clear()
{
    m_container.Clear();
}

void MaximalPreprocessingContext::Measure(PixelPosition x, PixelPosition y, const GlyphBitmap &glyph)
{
    MaximalGlyphData storedGlyphData;

    storedGlyphData.m_fontIdentifier = glyph.fontIdentifier;
    storedGlyphData.m_glyphIndex = glyph.glyphIndex;
    storedGlyphData.m_characterPosition = glyph.characterPosition;
    storedGlyphData.m_position.x = x;
    storedGlyphData.m_position.y = y;
    storedGlyphData.m_advance.width = glyph.xadvance;
    storedGlyphData.m_advance.height = glyph.yadvance;
    storedGlyphData.m_rect.SetLeft(glyph.left);
    storedGlyphData.m_rect.SetWidth(glyph.width);
    storedGlyphData.m_rect.SetTop(glyph.top);
    storedGlyphData.m_rect.SetHeight(glyph.height);
    storedGlyphData.m_direction = glyph.direction;

    static_cast<void>(m_container.Add(storedGlyphData));
}

MaximalPreprocessingContext::ReferenceIterator* MaximalPreprocessingContext::GetReferenceIterator() const
{
    return Internal::PreprocessingContextVectorIterator<DataContainer, PreprocessingContext::ReferenceIterator>
        (m_container.ConstBegin(), m_container.ConstEnd()).Clone();
}

    }    // namespace TextRendering
}    // namespace Candera

