//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/TextEngine/LayoutingOptions.h>


namespace Candera {

    namespace TextRendering {


        LayoutingOptions::LayoutingOptions(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, const TextCoordinate &offset, const TextSize& size, bool isMultilineTextEnabled, bool isWordWrapEnabled /*= false*/, PixelSize lineSpacing /*= 0*/, PixelSize glyphSpacing /*= 0*/, bool isRightToLeftDirection /*= false*/, bool isOrientationRealignmentEnabled /*= false*/) :
            m_isMultilineTextEnabled(isMultilineTextEnabled),
            m_isWordWrapEnabled(isWordWrapEnabled),
            m_isRightToLeftDirection(isRightToLeftDirection),
            m_isOrientationRealignmentEnabled(isOrientationRealignmentEnabled),
            m_isCultureHandlingRequired(true),
            m_horizontalAlignment(horizontalAlignment),
            m_verticalAlignment(verticalAlignment),
            m_lineSpacing(lineSpacing),
            m_glyphSpacing(glyphSpacing),
            m_offset(offset),
            m_size(size),
            m_strategy(0)
        {

        }


        LayoutingOptions::LayoutingOptions(const TextCoordinate &offset) :
            m_isMultilineTextEnabled(true),
            m_isWordWrapEnabled(false),
            m_isRightToLeftDirection(false),
            m_isOrientationRealignmentEnabled(false),
            m_isCultureHandlingRequired(true),
            m_horizontalAlignment(HLeft),
            m_verticalAlignment(VTop),
            m_lineSpacing(0),
            m_glyphSpacing(0),
            m_offset(offset),
            m_strategy(0)
        {

        }


        LayoutingOptions::LayoutingOptions() :
            m_isMultilineTextEnabled(true),
            m_isWordWrapEnabled(false),
            m_isRightToLeftDirection(false),
            m_isOrientationRealignmentEnabled(false),
            m_isCultureHandlingRequired(true),
            m_horizontalAlignment(HLeft),
            m_verticalAlignment(VTop),
            m_lineSpacing(0),
            m_glyphSpacing(0),
            m_strategy(0)
        {

        }

        void LayoutingOptions::SetOffset(const TextCoordinate &offset)
        {
            m_offset = offset;
        }

        const Candera::TextRendering::TextCoordinate& LayoutingOptions::GetOffset() const
        {
            return m_offset;
        }

        void LayoutingOptions::SetHorizontalAlignment(HorizontalAlignment alignment)
        {
            m_horizontalAlignment = alignment;
        }

        HorizontalAlignment LayoutingOptions::GetHorizontalAlignment() const
        {
            return m_horizontalAlignment;
        }

        void LayoutingOptions::SetVerticalAlignment(VerticalAlignment alignment)
        {
            m_verticalAlignment = alignment;
        }

        VerticalAlignment LayoutingOptions::GetVerticalAlignment() const
        {
            return m_verticalAlignment;
        }

        void LayoutingOptions::SetSize(const TextSize& size)
        {
            m_size = size;
        }

        const Candera::TextRendering::TextSize& LayoutingOptions::GetSize() const
        {
            return m_size;
        }

        void LayoutingOptions::SetLineSpacing(PixelSize lineSpacing)
        {
            m_lineSpacing = lineSpacing;
        }

        Candera::TextRendering::PixelSize LayoutingOptions::GetLineSpacing() const
        {
            return m_lineSpacing;
        }

        void LayoutingOptions::SetGlyphSpacing(PixelPosition glyphSpacing)
        {
            m_glyphSpacing = glyphSpacing;
        }

        Candera::TextRendering::PixelPosition LayoutingOptions::GetGlyphSpacing() const
        {
            return m_glyphSpacing;
        }

        void LayoutingOptions::SetMultilineTextEnabled(bool isMultilineTextEnabled)
        {
            m_isMultilineTextEnabled = isMultilineTextEnabled;
        }

        bool LayoutingOptions::IsMultilineTextEnabled() const
        {
            return m_isMultilineTextEnabled;
        }

        void LayoutingOptions::SetWordWrapEnabled(bool isWordWrapEnabled)
        {
            m_isWordWrapEnabled = isWordWrapEnabled;
        }

        bool LayoutingOptions::IsWordWrapEnabled() const
        {
            return m_isWordWrapEnabled;
        }

        void LayoutingOptions::SetLayoutStrategy(TextLayoutStrategy* strategy)
        {
            m_strategy = strategy;
        }

        Candera::TextRendering::TextLayoutStrategy* LayoutingOptions::GetLayoutStrategy() const
        {
            return m_strategy;
        }

        bool LayoutingOptions::IsRightToLeftDirection() const
        {
            return m_isRightToLeftDirection;
        }

        void LayoutingOptions::SetRightToLeftDirection(bool isRightToLeftDirection)
        {
            m_isRightToLeftDirection = isRightToLeftDirection;
        }

        bool LayoutingOptions::IsOrientationRealignmentEnabled() const
        {
            return m_isOrientationRealignmentEnabled;
        }

        void LayoutingOptions::SetOrientationRealignmentEnabled(bool isOrientationRealignmentEnabled)
        {
            m_isOrientationRealignmentEnabled = isOrientationRealignmentEnabled;
        }


        bool LayoutingOptions::IsCultureHandlingRequired() const
        {
            return m_isCultureHandlingRequired;
        }

        void LayoutingOptions::SetCultureHandlingRequired(bool isCultureHandlingRequired)
        {
            m_isCultureHandlingRequired = isCultureHandlingRequired;
        }

    }
}
