//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_UnibreakInclude_h)
#define Candera_UnibreakInclude_h

#include <Candera/Environment.h>
#include <Candera/TextEngine/Types.h>

// Include this to avoid it being included from withing the Unibreak namespace.
#include <stddef.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {
            namespace Unibreak {

#define LINEBREAK_UTF_TYPES_DEFINED
typedef Candera::TextRendering::Utf8    utf8_t;     /**< Type for UTF-8 data points */
typedef Candera::TextRendering::Utf16   utf16_t;    /**< Type for UTF-16 data points */
typedef Candera::TextRendering::Utf32   utf32_t;    /**< Type for UTF-32 data points */

// Import external C libraries in C++ namespace.
#ifdef CANDERA_MULTILINE_TEXT_ENABLED
#include <linebreak.h>
#include <linebreakdef.h>
#include <wordbreak.h>
#include <wordbreakdef.h>
#else
struct lineBreakContext {};
struct wordBreakContext {};
#endif
            }
        }
    }
}

#endif    // Candera_UnibreakInclude_h
