//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#ifndef CANDERA_TEXTENGINE_TrueTypeStyleMap_h
#define CANDERA_TEXTENGINE_TrueTypeStyleMap_h

#include <Candera/TextEngine/Types.h>
#include <FeatStd/Util/String.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {
            /**
            * This class resolves the TrueType specification for the style.
            * Spec:
            * https://developer.apple.com/fonts/TrueType-Reference-Manual/RM06/Chap6head.html
            * head-Table - entry macStyle:
            * bit 0 bold
            * bit 1 italic
            * bit 2 underline
            * bit 3 outline
            * bit 4 shadow
            * bit 5 condensed (narrow)
            * bit 6 extended
            *
            * Currently supported return values:
            * - Regular
            * - Bold
            * - Italic
            * - Bold Italic
            */
            class TrueTypeStyleMap {
            public:
                static FeatStd::String const& GetTrueTypeStyleName(UInt16 macStyle);

            private:
                struct TrueTypeStyle {
                    UInt16 m_styleFlags;
                    FeatStd::String m_styleName;
                };
                static const TrueTypeStyle m_styles[4];
            };
        }
    }
}

#endif // CANDERA_TEXTENGINE_TrueTypeStyleMap_h
