//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#ifndef CANDERA_TEXTENGINE_TrueTypeCMapChooser_h
#define CANDERA_TEXTENGINE_TrueTypeCMapChooser_h

#include <Candera/TextEngine/Types.h>
namespace Candera {
    namespace TextRendering {
        namespace Internal {

            /**
            * The TrueType character map selection is based on the standard:
            * https://developer.apple.com/fonts/TrueType-Reference-Manual/RM06/Chap6cmap.html
            * This system orders the entries in the order that is supposed to be the best for CGIStudio.
            * Therefore, Unicode (UCS-4) followed by UCS-2 are the most recommended ones.
            * Order:
            * - Custom one
            * - {3, 10}, // Windows, Unicode UCS-4
            * - {3, 1}, // Windows, Unicode UCS-2
            * - {0, 4}, // Unicode 2.0 or later (preferred usage on OS X and iOS)
            * - {0, 3}, // Unicode (older version than 0,4)
            * - {0, 2}, // Unicode (older version than 0,3)
            * - {0, 1}, // Unicode (older version than 0,2)
            * - {0, 0}, // Unicode (older version than 0,1)
            *
            */
            class TrueTypeCMapChooser {
            public:
                struct CMapEntry {
                    UInt16 platformID;
                    UInt16 platformSpecificID;
                };

                static TrueTypeCMapChooser& GetInstance();

                void SetCustomCMap(UInt16 platformID, UInt16 platformSpecificID);

                void ResetCustomCMap();

                SizeType GetMapEntryCount() const;

                CMapEntry const& GetCMapEntry(SizeType idx) const;

                SizeType GetIndexOfMap(UInt16 platformID, UInt16 platformSpecificID) const;

            private:
                TrueTypeCMapChooser();

                CMapEntry m_customMap;
                static CMapEntry const m_CMapEntries[];

            };

        }
    }
}

#endif // CANDERA_TEXTENGINE_TrueTypeCMapChooser_h

