//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/TextEngine/Internal/TextProcessResult.h>
#include <Candera/TextEngine/TextEngineMemoryPool.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {

            TextProcessResult::SharedPointer TextProcessResult::Create()
            {
                return TextProcessResult::SharedPointer(TEXTENGINE_TRANSIENT_NEW(TextProcessResult)());
            }

            Candera::TextRendering::GlyphDataContainer::SharedPointer TextProcessResult::GetResultContainer() const
            {
                return m_resultContainer;
            }

            void TextProcessResult::SetResultContainer(Candera::TextRendering::GlyphDataContainer::SharedPointer& val)
            {
                m_resultContainer = val;
            }

            Candera::TextRendering::TextRect TextProcessResult::GetResultTextRectangle() const
            {
                return m_resultTextRectangle;
            }

            void TextProcessResult::SetResultTextRectangle(Candera::TextRendering::TextRect const& val)
            {
                m_resultTextRectangle = val;
            }

            Candera::TextRendering::TextRect TextProcessResult::GetResultLayoutRectangle() const
            {
                return m_resultLayoutRectangle;
            }

            void TextProcessResult::SetResultLayoutRectangle(Candera::TextRendering::TextRect const& val)
            {
                m_resultLayoutRectangle = val;
            }

            Candera::TextRendering::SharedStyle::SharedPointer TextProcessResult::GetStyle() const
            {
                return m_resultStyle;
            }

            void TextProcessResult::SetStyle(Candera::TextRendering::SharedStyle::SharedPointer& val)
            {
                m_resultStyle = val;
            }

            Candera::TextRendering::TextCoordinate TextProcessResult::GetOffset() const
            {
                return m_offset;
            }

            void TextProcessResult::SetOffset(Candera::TextRendering::TextCoordinate const& val)
            {
                if ((m_offset.GetX() != val.GetX()) || (m_offset.GetY() != val.GetY()))
                {
                    m_offset = val;
                    m_resultAnalyzed = false;
                }
            }


            bool TextProcessResult::IsResultConsumed() const
            {
                return m_resultAnalyzed;
            }

            TextProcessResult::TextProcessResult() :
                m_resultContainer(),
                m_resultStyle(),
                m_resultLayoutRectangle(TextRect::GetMin()),
                m_resultTextRectangle(TextRect::GetMin()),
                m_offset(),
                m_resultAnalyzed(false)
            {

            }

            void TextProcessResult::SetResultConsumed(bool val)
            {
                m_resultAnalyzed = val;
            }

        }
    }
}
