//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_TextEngine_TextProcessHelper_h
#define Candera_TextEngine_TextProcessHelper_h

namespace Candera {
    namespace TextRendering {
        class TextRenderContext;
        namespace Internal {
            class TextProcessProperties;
            class TextProcessResult;

            /**
            * @brief TextProcessHelper is a helper class to generate a result out of properties (text processing) and 
            * blit the result (text rendering).
            */
            class TextProcessHelper {
            public:

                /**
                * Method which processes text and produces a result.
                * @param properties contains all the required properties to process a text.
                * @param result contains all the information which is generated out of the text processing
                * this contains the glyph iterator and the bounding box of the text.
                * Typical failures (false) here are style not set.
                */
                static bool ProcessText(TextProcessProperties& properties, TextProcessResult& result);

                /**
                * Method which renders the text. There wont be done any glyph positioning which is done when calling ProcessText.
                * The renderer iterates over the glyph iterator and calls the blit method of the render context for every glyph.
                * It provides two influences on the result which is the offset of the text - so the calculated x and y coordinate can be moved by this offset.
                * The second influence is the Clipping rectangle of the render context which can be used to hide glyphs as they will not be rendered.
                * Further logic can be implemented into the blit method of the render context.
                * @param properties contains all the information (glyph iterator and offset) which is required to render the text.
                * @param renderContext receiver of the glyphs which shall be rendered.
                * @return success of calling the renderer. 
                * Typical failures (false) here are style not set or glyph iterator not set.
                */
                static bool RenderText(TextProcessResult const& properties, TextRenderContext& renderContext);
            };
        }
    }
}

#endif // Candera_TextEngine_TextProcessHelper_h
