//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TextPointer.h"
#include <Candera/TextEngine/Internal/FullBoundCodePointIterator.h>

namespace Candera {
    namespace TextRendering { 
        namespace Internal {

TextPointer TextPointer::GetTCharPosition(const TChar* text, TextLength textLength, TextPointer start, TextPosition position)
{
    FullBoundCodePointIterator it(start.GetTChar(text), textLength - static_cast<TextLength>(start.GetPosition()));
    while(position-- > 0) {
        start += static_cast<TextLength>(it.Advance());
    }
    return start;
}

TextPosition TextPointer::GetCodePointPosition(const TChar* text, TextPointer start, TextPointer position)
{
    FullBoundCodePointIterator it(start.GetTChar(text), position - start);
    TextPosition current = 0;
    while((*it) != 0) {
        start += static_cast<TextLength>(it.Advance());
        ++current;
    }
    return current;
}

        }
    }
} //namespaces.
