//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_StyleTools_h)
#define Candera_StyleTools_h

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/Style.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {

/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 * @brief Class for identifying fonts within styles.
 */
class StyleTools {
public:
    /**
     * Determine the identifier of the font corresponding to a certain code point.
     * The identifier uniquely identify fonts within the style.
     * The identifier is valid as long as the style does not change.
     * Code point availability within the font is checked when choosing the font.
     * @param style Style that contains the font.
     * @param codePoint The codepoint looked up within the style.
     * @return Identifier of the font.
     */
    static FontIdentifier GetFontIdentifierByCodePoint(const Style& style, Utf32 codePoint);
    static const Font& GetFontByIdentifier(const Style& style, FontIdentifier identifier);

    static UInt16 GetStyleVersion(const Style& style) { return style.GetVersion(); }
};

/** @} */ // end of CanderaTextEngine

        } // namespace Internal
    }// namespace TextRendering
}// namespace Candera


#endif// Candera_Style_h
