//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#include "Shaper.h"

#if ((defined(CANDERA_TEXT_SHAPER_COMPLEXSCRIPTLIB)) || (defined(CANDERA_TEXTSHAPER_COMPLEXSCRIPT_FORCE_ENABLED)))
#include <Candera/TextEngine/Internal/ComplexScriptShaper/CsShaper.h>
#endif
#if ((defined(CANDERA_TEXT_SHAPER_HARFBUZZ)) || (defined(CANDERA_TEXTSHAPER_HARFBUZZ_FORCE_ENABLED)))
#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbShaper.h>
#endif
#if ((defined(CANDERA_TEXT_SHAPER_WORLDTYPE)) || (defined(CANDERA_TEXTSHAPER_WORLDTYPE_FORCE_ENABLED)))
#include <Candera/TextEngine/Internal/WorldTypeShaper/WtShaper.h>
#endif
#include <Candera/TextEngine/Internal/NullShaper.h>
#include <FeatStd/Util/StaticObject.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {
            class ShaperList {
            public:

#if ((defined(CANDERA_TEXT_SHAPER_COMPLEXSCRIPTLIB)) || (defined(CANDERA_TEXTSHAPER_COMPLEXSCRIPT_FORCE_ENABLED)))
                static ComplexScriptShaper::CsShaper& GetComplexScriptShaper()
                {
                    FEATSTD_UNSYNCED_STATIC_OBJECT(ComplexScriptShaper::CsShaper, s_csShaper);
                    return s_csShaper;
                }
#endif

#if ((defined(CANDERA_TEXT_SHAPER_WORLDTYPE)) || (defined(CANDERA_TEXTSHAPER_WORLDTYPE_FORCE_ENABLED)))
                static WtShaper& GetWorldTypeShaper()
                {
                    FEATSTD_UNSYNCED_STATIC_OBJECT(WtShaper, s_wtShaper);
                    return s_wtShaper;
                }
#endif

#if  ((defined(CANDERA_TEXT_SHAPER_HARFBUZZ)) || (defined(CANDERA_TEXTSHAPER_HARFBUZZ_FORCE_ENABLED)))
                static HarfBuzzShaper::HbShaper& GetHarfBuzzShaper()
                {
                    FEATSTD_UNSYNCED_STATIC_OBJECT(HarfBuzzShaper::HbShaper, s_hbShaper);
                    return s_hbShaper;
                }
#endif

                static NullShaper& GetNullShaper()
                {
                    FEATSTD_UNSYNCED_STATIC_OBJECT(NullShaper, s_nullShaper);
                    return s_nullShaper;
                }
                static Shaper* cDefaultShaper;
                static void InitDefaultShaper()
                {
                    if (cDefaultShaper == 0) {
#if defined(CANDERA_TEXT_SHAPER_WORLDTYPE) // no force check - as the default shall be the selected one
                        cDefaultShaper = &ShaperList::GetWorldTypeShaper();
#elif defined(CANDERA_TEXT_SHAPER_HARFBUZZ) // no force check - as the default shall be the selected one
                        cDefaultShaper = &ShaperList::GetHarfBuzzShaper();
#elif defined(CANDERA_TEXT_SHAPER_COMPLEXSCRIPTLIB) // no force check - as the default shall be the selected one
                        cDefaultShaper = &ShaperList::GetComplexScriptShaper();
#else
                        cDefaultShaper = &ShaperList::GetNullShaper();
#endif
                    }
                    FEATSTD_DEBUG_ASSERT(ShaperList::cDefaultShaper != 0); // Mandatory
                }
            };

            Shaper* ShaperList::cDefaultShaper = 0;

            Shaper::~Shaper()
            {

            }

            void Shaper::SetDefaultShaperInstance(Shaper* shaper)
            {
                ShaperList::cDefaultShaper = shaper;
            }

            Candera::TextRendering::Internal::Shaper& Shaper::GetDefaultShaperInstance()
            {
                ShaperList::InitDefaultShaper();
                return *ShaperList::cDefaultShaper;
            }


            Candera::TextRendering::Internal::Shaper& Shaper::GetShaperInstance(ShaperType::Enum shaperType)
            {
                CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1960, CANDERA_LINT_REASON_RETURNINCASE);
                switch (shaperType) {
                case Candera::TextRendering::ShaperType::NoShaper:
                    return ShaperList::GetNullShaper();
#if ((defined(CANDERA_TEXT_SHAPER_COMPLEXSCRIPTLIB)) || (defined(CANDERA_TEXTSHAPER_COMPLEXSCRIPT_FORCE_ENABLED)))
                case Candera::TextRendering::ShaperType::ComplexScript:
                    return ShaperList::GetComplexScriptShaper();
#endif
#if ((defined(CANDERA_TEXT_SHAPER_HARFBUZZ)) || (defined(CANDERA_TEXTSHAPER_HARFBUZZ_FORCE_ENABLED)))
                case Candera::TextRendering::ShaperType::HarfBuzz:
                    return ShaperList::GetHarfBuzzShaper();
#endif
#if ((defined(CANDERA_TEXT_SHAPER_WORLDTYPE)) || (defined(CANDERA_TEXTSHAPER_WORLDTYPE_FORCE_ENABLED)))
                case Candera::TextRendering::ShaperType::WorldTypeShaper:
                    return ShaperList::GetWorldTypeShaper();
#endif
                default:
                    return GetDefaultShaperInstance();
                }
            }

        }
    }
}
