//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_PreprocessingContextVectorIterator_h)
#define Candera_PreprocessingContextVectorIterator_h

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/PreprocessingContext.h>
#include <Candera/TextEngine/TextEngineMemoryPool.h>

#include <FeatStd/Container/Vector.h>

namespace Candera { namespace TextRendering { namespace Internal {

/** @addtogroup CanderaTextEngine
 *  @{
 */
 
/**
 * @brief Class that allows iteration over preprocessed GlyphData stored in vectors.
 */
template <typename V, typename O>
class PreprocessingContextVectorIterator : public O
{
public:
    typedef V Vector;
    typedef typename Vector::ConstIterator Iterator;
    typedef O ReferenceIterator;

    PreprocessingContextVectorIterator(const Iterator& start, const Iterator& end);

    // Override functions from ReferenceIterator.
    virtual ReferenceIterator* Clone() const override final;
    virtual void Destroy() override final;
    virtual bool IsValid() const override final;
    virtual const PreprocessingContext::GlyphData* GetData() const override final;
    virtual void Advance() override final;

private:
    Iterator m_start;
    Iterator m_end;
};

 /** @} */ // end of CanderaTextEngine
 
template <typename V, typename O>
PreprocessingContextVectorIterator<V, O>::PreprocessingContextVectorIterator(const Iterator& start, const Iterator& end) :
    m_start(start),
    m_end(end)
{
}

template <typename V, typename O>
typename PreprocessingContextVectorIterator<V, O>::ReferenceIterator* PreprocessingContextVectorIterator<V, O>::Clone() const
{
    return TEXTENGINE_TRANSIENT_NEW(PreprocessingContextVectorIterator)(*this);
}

template <typename V, typename O>
void PreprocessingContextVectorIterator<V, O>::Destroy()
{
    return TEXTENGINE_DELETE(this);
}

template <typename V, typename O>
bool PreprocessingContextVectorIterator<V, O>::IsValid() const
{
    return m_start != m_end;
}

template <typename V, typename O>
const PreprocessingContext::GlyphData* PreprocessingContextVectorIterator<V, O>::GetData() const
{
    return &*const_cast<Iterator&>(m_start);
}

template <typename V, typename O>
void PreprocessingContextVectorIterator<V, O>::Advance()
{
    FEATSTD_DEBUG_ASSERT(IsValid());
    ++m_start;
}

}// namespace Internal
}// namespace TextRendering
}// namespace Candera

#endif// Candera_PreprocessingContextVectorIterator_h
