//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "PlacementTextRenderContext.h"

namespace Candera { namespace TextRendering { namespace Internal {


    PlacementTextRenderContext::PlacementTextRenderContext(Int16 places[]) :
        m_places(places)
    {
    }

    const TextRect& PlacementTextRenderContext::GetClipRect() const
    {
        return TextRect::GetMax();
    }

    void PlacementTextRenderContext::Blit(Int16 x, Int16 /*y*/, const GlyphBitmap &/*glyph*/)
    {
        //compute final advance
        *m_places++ = x;
    }

        }    //namespace Internal
    }    // namespace TextRendering
}    // namespace Candera
