//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_ParserData_h)
#define Candera_ParserData_h

#include <Candera/Environment.h>
#include <Candera/TextEngine/Types.h>

#ifdef CANDERA_BIDIRECTIONAL_TEXT_ENABLED
#include <Candera/TextEngine/Internal/BidirectionalParser/BidirectionalParserData.h>
#else
namespace Candera { namespace TextRendering { namespace Internal {
class BidirectionalParserData { public: bool Initialize(const TChar*, TextLength, UInt8, bool) { return true; } };
}}}
#endif


namespace Candera {
    namespace Globalization {
        class Culture;
    }
    namespace TextRendering {
        namespace Internal {
            class Parser;

/** @addtogroup CanderaTextEngine
 *  @{
 */
            /**
             * Object holding persistent data for the parser.
             */
            class ParserData {
                friend class Parser;

            public:
                /**
                 * Initialize the parser.
                 * 
                 * Initialize the parser with the given text.
                 * @param text Text to be parsed.
                 * @param size Size of text to be parsed.
                 * @param culture The active culture for this text
                 * @param isMultilineTextEnabled removes line breaks if disabled
                 * @param layoutIsRightToLeft determines RTL-Culture direction. Precondition is: BidiBaseLevel::Deprecated.
                 * @param bidiBaseLevel sets an explicit base level direction for the text. If bidiBaseLevel is not Deprecated, layoutIsRightToLeft will be ignored. 
                 */
                bool Initialize(const TChar* text, TextLength size = -1, const Globalization::Culture* culture = 0, bool isMultilineTextEnabled = true, bool layoutIsRightToLeft = false,
                                BidiBaseLevel::Enum bidiBaseLevel = BidiBaseLevel::Deprecated);

            private:
                static UInt8 GetCultureLevel(const Globalization::Culture* culture);
                static UInt8 GetDeprecatedLevel(const Globalization::Culture* culture, bool layoutIsRightToLeft);

                bool m_isMultilineEnabled;
                const TChar* m_text;
                TextLength m_size;

                BidirectionalParserData m_bidirectionalParserData;
            };

 /** @} */ // end of CanderaTextEngine

        }     // namespace Internal
    }    // namespace TextRendering
}    // namespace Candera

#endif    // Candera_ParserData_h

