//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_NullShaper_h)
#define Candera_NullShaper_h

#include <Candera/TextEngine/Internal/SimplifiedShaper.h>
#include <Candera/TextEngine/Internal/FullBoundCodePointIterator.h>

namespace Candera {
    namespace TextRendering {
        class Font;
        namespace Internal {
            class GlyphRenderer;

class NullShaper : public SimplifiedShaper
{
public:
    NullShaper();
    virtual ~NullShaper() ;
protected:
    virtual bool InitializeUnicode(const TChar* text, TextLength textLength, const ShaperInfo& info) ;
    virtual UnicodeData GetUnicode() const;
    virtual void AdvanceUnicode() ;
    virtual bool IsEndUnicode() const ;
    virtual GlyphBitmap::Direction GetDirection() const { return m_direction; }
    
    virtual bool IsInCorrectOrder() const override { return m_isInCorrectOrder; }
private:
    bool m_isInCorrectOrder;
    const TChar* m_text;
    GlyphBitmap::Direction m_direction;
    FullBoundCodePointIterator m_iterator;
}; // class NullShaper 

        } // namespace Internal
    } // namespace TextRendering
} // namespace Candera

#endif// Candera_NullShaper_h
