//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_HbShaper_h)
#define Candera_HbShaper_h

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/GlyphBitmap.h>
#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbInclude.h>
#include <Candera/TextEngine/Internal/Shaper.h>
#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbFreetypeFont.h>

namespace Candera {
    namespace TextRendering {
        class Font;

        namespace Internal {
            class GlyphRenderer;
            class ShaperInfo;
            namespace HarfBuzzShaper {

class HbShaper : public Shaper
{
    public:
        HbShaper();
        ~HbShaper();

        virtual bool Initialize(const GlyphRenderer& glyphRenderer, const Font &font, const TChar* text, TextLength textSize, const ShaperInfo& info) override;

        virtual GlyphIndex GetGlyph() const override;
        virtual TextPosition GetCharacterPosition() const override;
        virtual void CorrectGlyphBitmap(GlyphBitmap& glyph) const override;
        virtual GlyphBitmap::Direction GetDirection() const override;

        virtual void Advance() override;
        virtual bool IsEnd() const override;

        virtual void CleanUp();

    private:
        FEATSTD_MAKE_CLASS_UNCOPYABLE(HbShaper);

        Int m_numGlyph;
        Int m_currentGlyph;
        hb_glyph_info_t *m_glyph;
        hb_glyph_position_t *m_position;

        hb_buffer_t* m_buffer;
        HbFreetypeFont m_font;
}; // class HbShaper

            } // namespace HarfBuzzShaper
        } // namespace Internal
    } // namespace TextRendering
} // namespace Candera

#endif// Candera_HbShaper_h
