//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbInclude.h>

#include <Candera/TextEngine/TextEngineMemoryPool.h>
#include <FeatStd/Container/Vector.h>
#include <FeatStd/Platform/String.h>
#include <FeatStd/Util/NumericUtil.h>

namespace Candera { namespace TextRendering { namespace Internal { namespace HarfBuzzShaper {

extern "C" void *hb_smalloc(hb_ssize_t size)
{
    return TEXTENGINE_ALLOC(static_cast<UInt32>(size));
}

extern "C" void hb_sfree(void *ptr)
{
    TEXTENGINE_FREE(ptr);
}

extern "C" void *hb_scalloc(hb_ssize_t nmemb, hb_ssize_t size)
{
    hb_ssize_t combinedSize = nmemb * size;
    void* address = hb_smalloc(combinedSize);
    if (address != 0) {
        FeatStd::Internal::Memory::Set(address, 0, combinedSize);
    }
    return address;
}

extern "C" void *hb_srealloc(void *ptr, hb_ssize_t size)
{
    return TEXTENGINE_REALLOC(ptr, static_cast<UInt32>(size));
}

extern "C" hb_schar *hb_sstrdup(const hb_schar *s)
{
    UInt32 sLen = FeatStd::Internal::NumericConversion<UInt32>(FeatStd::Internal::String::Length(s) + 1U);
    hb_schar* data = FeatStd::Internal::PointerToPointer<hb_schar*>(hb_smalloc(sLen));
    if (data != 0) {
        FeatStd::Internal::String::Copy(data, s);
    }
    return data;
}

extern "C" hb_sint hb_satexit(void (*function)(void))
{
    typedef void (*FunctionType)(void);
    static struct AtExit {
        FeatStd::Internal::Vector<FunctionType> m_functionVector;
        ~AtExit() 
        {
            for (SizeType i = 0; i < m_functionVector.Size(); i++) {
                m_functionVector[i]();
            }
        }
    } s_container;

    return s_container.m_functionVector.Add(function) ? 0 : 1;
}

}}}} // current namespace
