//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#ifndef CANDERA_TEXTENGINE_GlyphCacheMap_h
#define CANDERA_TEXTENGINE_GlyphCacheMap_h

#include <FeatStd/Container/HashTable.h>
#include <Candera/TextEngine/Types.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {
            
            class GlyphCacheMap {
            public:
                GlyphCacheMap();
                bool AddEntry(GlyphIndex const& key, UInt8* value);

                UInt8* GetEntry(GlyphIndex const& key) const;

                bool RemoveEntry(GlyphIndex const& key);
                
                void Flush();

                SizeType GetCount() const;

            private:
                FeatStd::Internal::HashTable<GlyphIndex, UInt8*> m_glyphCacheMap;
                SizeType m_entryCount;
            };

        }
    }
}

#endif // CANDERA_TEXTENGINE_GlyphCacheMap_h


