//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_FullBoundCodePointIterator_h)
#define Candera_FullBoundCodePointIterator_h

#include <Candera/TextEngine/Types.h>
#include <FeatStd/Util/TextEncoding.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {

        /** @addtogroup CanderaTextEngine
        *  @{
        */

        /** @brief FullBoundCodePointIterator iterates over the code points in an encoded
         *  bound string, skipping broken code points
         */
        class FullBoundCodePointIterator {
            typedef FeatStd::Internal::BoundTextIterator Iterator;
        public:
            static const CodePoint c_defaultCharacter = 0xFFFDU;

            FullBoundCodePointIterator(const TChar *text, TextLength count) :
                m_iterator(text, count)
            {
            }

            /** Advances read position to next code point. Misformated codepoints are skipped.
                @return number of Chars the read pointer has been moved */
            inline TextLength Advance() {
                return static_cast<TextLength>(m_iterator.Advance());
            }

            /** returns the code point at read positon */
            inline CodePoint operator*() const {
                CodePoint codepoint = *m_iterator;
                if (codepoint == ~0U) {
                    // Instead of invalid unicode character
                    // return default unicode character, for proper
                    // parsing of the codepoint.
                    return c_defaultCharacter;
                }
                return codepoint;
            }

            /** returns the read positon */
            inline const TChar* Pos() const {
                return m_iterator.Pos();
            }

        private:
            Iterator m_iterator;
        };

        /** @} */ // end of CanderaTextEngine
        }
    }// namespace TextRendering
}// namespace Candera


#endif// Candera_FullBoundCodePointIterator_h
