//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_FontStyleIterator_h)
#define Candera_FontStyleIterator_h

#include <Candera/Environment.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {

            /**
             * Class for iterating over font styles contained by at TTC font.
             */
            class FontStyleIterator
            {
            public:

                /**
                 * @param faceName If the faceName is a valid name for the FonsStore, the iterator shall be a valid. 
                 */
                FontStyleIterator(const Char* faceName);

                /**
                 * Constructor for an invalid iterator.
                 */
                FontStyleIterator();

                ~FontStyleIterator() {};

                //requirements for thr ForwardIterator interface.
                typedef const Char* ValueType;
                typedef const Char* PointerType;
                typedef const Char* ReferenceType;
                bool operator!=(const FontStyleIterator& other) const;
                const Char* operator*() const;
                FontStyleIterator operator++(Int) const;
                FontStyleIterator& operator++();

            private:
                Int16 m_index;
                const Char* m_faceName;
            };

        }
    }
}

#endif
