//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "FontStyleIterator.h"

#include <Candera/TextEngine/Font.h>


namespace Candera {
    namespace TextRendering {
        namespace Internal {

            FontStyleIterator::FontStyleIterator(const Char* faceName) :m_index(0), m_faceName(faceName)
            {
                if (**this == 0) {
                    m_index = -1;
                    m_faceName = 0;
                }
            }

            FontStyleIterator::FontStyleIterator() :m_index(-1), m_faceName(0)
            {
            }

            bool FontStyleIterator::operator!=(const FontStyleIterator& other) const
            {
                return (m_index != other.m_index) || (m_faceName != other.m_faceName);
            }

            const Char* FontStyleIterator::operator*() const
            {
                if (m_index < 0) {
                    return 0;
                }
                return Font::GetStyleName(m_faceName, static_cast<UInt8>(m_index));
            }

            // Post-increment
            FontStyleIterator FontStyleIterator::operator++(Int) const
            {
                FontStyleIterator it = *this;
                return ++it;
            }

            FontStyleIterator& FontStyleIterator::operator++()
            {
                ++m_index;
                if (**this == 0) {
                    m_index = -1;
                    m_faceName = 0;
                }
                return *this;
            }
        }
    }
}
