//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_BidiUnicode_h)
#define Candera_BidiUnicode_h

#include <Candera/Environment.h>
#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/Internal/TextPointer.h>


namespace Candera {
    namespace TextRendering {
        namespace Internal {

/** @addtogroup CanderaTextEngine
 *  @{
 */

            /**
             *  Class that handles the unicode bidirectional algorithm.
             */
            class BidiUnicode {
            public:

                enum BidiClassEnum {
                             // ON MUST be zero, code relies on ON = N = 0
                    ON,      ///< Other Neutral
                    L,       ///< Left Letter
                    R,       ///< Right Letter
                    AN,      ///< Arabic Number
                    EN,      ///< European Number
                    AL,      ///< Arabic Letter (Right-to-left)
                    NSM,     ///< Non-spacing Mark
                    CS,      ///< Common Separator
                    ES,      ///< European Separator
                    ET,      ///< European Terminator (post/prefix e.g. $ and %)

                    // resolved types
                    BN,      ///< Boundary neutral (type of RLE etc after explicit levels)

                    // input types,
                    S,         ///< Segment Separator (TAB)        // used only in L1
                    WS,        ///< White space                    // used only in L1
                    B,         ///< Paragraph Separator (aka as PS)

                    // types for explicit controls
                    RLO,     ///< these are used only in X1-X9
                    RLE,     ///< these are used only in X1-X9
                    LRO,     ///< these are used only in X1-X9
                    LRE,     ///< these are used only in X1-X9
                    PDF      ///< these are used only in X1-X9
                };

                static BidiClassEnum GetBidiClass(CodePoint codepoint);
                static TextLength ResolveNClasses(UInt8 *classes, const TChar* text, TextPointer start, TextPointer end);
                static TextLength ResolveClasses(UInt8 *classes, const TChar* text, TextPointer start, TextPointer end);
                static TextLength GenerateParagraphLevels(UInt8 *levels, UInt8 *classes, const TChar* text, TextPointer start, TextPointer end, UInt8 level);
                static TextLength GenerateLineLevels(UInt8 *levels, const UInt8 *classes, const TChar* text, TextPointer start, TextPointer end, UInt8 level);

            private:
            
                struct BidiClassData {
                    CodePoint start;
                    CodePoint end;
                    BidiClassEnum type;
                };

                static const BidiClassData g_bidiClassTable[];
                static const UInt32 g_bidiClassTableSize;
            };

 /** @} */ // end of CanderaTextEngine

        }     // namespace Internal
    }    // namespace TextRendering
}    // namespace Candera

#endif    // Candera_BidiUnicode_h
