//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlyphTextMeasureContext.h"

namespace Candera { namespace TextRendering {

    GlyphTextMeasureContext::GlyphTextMeasureContext(const TextRenderContext* referenceContext) :
        TextMeasureContext(referenceContext),
        m_textRectangle(TextRect::GetMin())
    {
    }

    void GlyphTextMeasureContext::Measure(PixelPosition x, PixelPosition y, const GlyphBitmap &glyph)
    {
        // compute bounds
        PixelPosition left = x;
        PixelPosition right = (x + static_cast<PixelPosition>(glyph.width)) - 1;

        PixelPosition top = y;
        PixelPosition bottom = (y + static_cast<PixelPosition>(glyph.height)) - 1;

        TextRect glyphRect(left, top, right, bottom);
        if (!glyphRect.IsEmpty()) {
            m_textRectangle = m_textRectangle.Union(glyphRect);
        }
    }

    const TextRect& GlyphTextMeasureContext::GetTextRectangle() const
    {
        return m_textRectangle.IsNegative() ? TextRect::GetDefault() : m_textRectangle;
    }

    }    // namespace TextRendering
}    // namespace Candera
