//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_FtEngineDefinition_h)
#define Candera_FtEngineDefinition_h

#include <Candera/TextEngine/Freetype/FtInclude.h>
#include <Candera/TextEngine/Freetype/FtFontEngine.h>
#include <Candera/TextEngine/Freetype/FtFont.h>
#include <Candera/TextEngine/Freetype/FtGlyphRenderer.h>
#include <Candera/TextEngine/Freetype/FtCustomGlyphCacheAccess.h>


/* if there is an application supplied FT2 cache configuration, include the according header file */
#if defined(CANDERA_FREETYPE_CACHE_CONFIG)
#include CANDERA_FREETYPE_CACHE_CONFIG
#endif

namespace Candera {
    namespace TextRendering {
        namespace FontEngineDefinition {

            typedef TextRendering::Internal::FtFont Font;
            typedef TextRendering::Internal::FtFontEngine FontEngine;
            typedef TextRendering::Internal::FtGlyphRenderer GlyphRenderer;
            typedef TextRendering::Internal::FtCustomGlyphCacheAccess GlyphCacheAccess;

#if !defined(CANDERA_FREETYPE_CACHE_CONFIG)
            // use default values for Freetype cache configuration
            typedef TextRendering::Internal::FtFontEngineCacheConfig<> FtFontEngineConfig;
#endif
        }
    }// namespace TextRendering
}// namespace Candera

#endif// Candera_FtEngineDefinition_h
