//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#ifndef CANDERA_TEXTRENDERING_FontSize_h
#define CANDERA_TEXTRENDERING_FontSize_h

#include <Candera/System/Mathematics/Vector2.h>

namespace Candera {
    namespace TextRendering {
        class FontSize {
        public:
            FontSize();

            FontSize(FeatStd::Int16 fontHeight);

            FontSize(FeatStd::Int16 fontHeight, Vector2 const& scale);

            FontSize(FeatStd::Int16 fontHeight, FeatStd::Float xScale, FeatStd::Float yScale);

            bool operator !=(FontSize const& other) const;

            FeatStd::Int16 GetHeight() const;

            Candera::Vector2 GetScale() const;

            void SetScale(Candera::Vector2 const& scale);

            void SetXScale(FeatStd::Float xScale);

            void SetYScale(FeatStd::Float yScale);
   
            FeatStd::Int16 GetScaledHeight() const;
  
            FeatStd::Int16 GetScaledWidth() const;

        private:
            Candera::Vector2 m_scale;
            FeatStd::Int16 m_height;
            FeatStd::Int16 m_width;
        };
    }
}


#endif // CANDERA_TEXTRENDERING_FontSize_h
