//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#include "FontSize.h"

#include <Candera/System/Mathematics/Vector2.h>

namespace Candera {
    namespace TextRendering {

        bool FontSize::operator!=(FontSize const& other) const
        {
            return (m_height != other.m_height) ||
                /*  (m_width != other.m_width) ||*/
                (m_scale != other.m_scale);
        }

        FontSize::FontSize(FeatStd::Int16 fontHeight, FeatStd::Float xScale, FeatStd::Float yScale) :
            m_scale(xScale, yScale),
            m_height(fontHeight),
            m_width(fontHeight)
        {

        }

        FontSize::FontSize(FeatStd::Int16 fontHeight, Vector2 const& scale) :
            m_scale(scale),
            m_height(fontHeight),
            m_width(fontHeight)
        {

        }

        FontSize::FontSize(FeatStd::Int16 fontHeight) :
            m_scale(1.0F, 1.0F),
            m_height(fontHeight),
            m_width(fontHeight)
        {

        }

        FontSize::FontSize() :
            m_scale(1.0F, 1.0F),
            m_height(0),
            m_width(0)
        {

        }

        FeatStd::Int16 FontSize::GetHeight() const
        {
            return m_height;
        }

        Candera::Vector2 FontSize::GetScale() const
        {
            return m_scale;
        }

        void FontSize::SetScale(Candera::Vector2 const& scale)
        {
            m_scale = scale;
        }

        void FontSize::SetXScale(FeatStd::Float xScale)
        {
            m_scale.SetX(xScale);
        }

        void FontSize::SetYScale(FeatStd::Float yScale)
        {
            m_scale.SetY(yScale);
        }

        FeatStd::Int16 FontSize::GetScaledHeight() const
        {
            return static_cast<FeatStd::Int16>(static_cast<FeatStd::Float>(m_height) * m_scale.GetY());
        }

        FeatStd::Int16 FontSize::GetScaledWidth() const
        {
            return static_cast<FeatStd::Int16>(static_cast<FeatStd::Float>(m_width)* m_scale.GetX());
        }

    }
}


