//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_FontEngine_h)
#define Candera_FontEngine_h

#include <Candera/TextEngine/FontEngineDefinition.h>

namespace Candera {

    namespace TextRendering {

        /** @addtogroup CanderaTextEngine
         *  @{
         */

        /**
         *  Font engine singleton.
         *  This class takes care for setting up the underlying
         *  font rendering technology
         */
        struct FontEngine : public FontEngineDefinition::FontEngine {
            typedef FontEngineDefinition::FontEngine Base;

        public:
            /**
             *  Returns the font engine instance.
             *  @return the font engine instance
             */
            static FontEngine& Instance();

            /**
             *  Initialize the font engine with the given font store object.
             *  Font store is required to provide font resource data to the font engine.
             *  The lifetime of the supplied object must extend at least until Shutdown is called.
             *  @param fontStore a font store object (must not be null)
             *  @return true if the font engine could be setup with the given store, false otherwise
             */
            bool Init(FontStore *fontStore);

            /**
             *  Shutdown the font engine.
             *  No more font action beyond this point
             */
            void Shutdown();

            /**
             *  Returns the font store object of the engine.
             *  @return the font store object of the engine.
             */
            FontStore* GetFontStore() const {
                return Base::GetFontStore();
            }

        private:
            bool _init;

            FontEngine();
            FontEngine(const FontEngine &);
            FontEngine& operator=(const FontEngine &);
        };

        /** @} */ // end of CanderaTextEngine

    }// namespace TextRendering

}// namespace Candera

#endif// Candera_FontEngine_h
