//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_TextEngine_ThreadingTextRenderDispatcher_h
#define Candera_TextEngine_ThreadingTextRenderDispatcher_h



#include <Candera/TextEngine/Async/TextRenderDispatcher.h>
CANDERA_UNIT_TEST_TESTCASE_DECLARATION(TextRenderDispatcherTest, RunThreading)
namespace FeatStd{
    class AsyncRequestDispatcher;
}
namespace Candera {
    namespace TextRendering {

        /** @addtogroup CanderaTextEngine
        *  @{
        */

        /**
        * @brief ThreadingTextRenderDispatcher Dispatches a text request through a worker thread.
        */
        class ThreadingTextRenderDispatcher : public TextRenderDispatcher{
        public:

            static ThreadingTextRenderDispatcher& GetInstance();

            virtual bool SetPriority(FeatStd::Internal::ThreadPriority::Enum priority, FeatStd::Internal::Thread::SetPriorityCallback callback); 

        protected:
            ThreadingTextRenderDispatcher();
            virtual FeatStd::AsyncRequestDispatcher * GetDispatcher() override;

            virtual void WaitForHandleFinished(TextRenderHandle handle) override;
            CANDERA_UNIT_TEST_TESTCASE_FRIEND(TextRenderDispatcherTest, RunThreading);

        };

        /** @} */ // end of CanderaTextEngine
    }// namespace TextRendering
}// namespace Candera
#endif // Candera_TextEngine_ThreadingTextRenderDispatcher_h
