//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ThreadingTextRenderDispatcher.h"

#include <FeatStd/Platform/Thread.h>
#include <FeatStd/Async/AsyncRequest.h>
#include <FeatStd/Async/AsyncRequestDispatcher.h>

namespace Candera {
    namespace TextRendering {


        ThreadingTextRenderDispatcher::ThreadingTextRenderDispatcher() {}

#ifndef _FEATSTD_OS_INTERNAL_THREAD_NOT_SUPPORTED
        static FeatStd::AsyncRequestDispatcherWorkerThread &GetDispatcherWorkerThread()
        {
            FEATSTD_SYNCED_STATIC_OBJECT(FeatStd::AsyncRequestDispatcherWorkerThread, dispatcher);
            return dispatcher;
        }
#endif

        FeatStd::AsyncRequestDispatcher* ThreadingTextRenderDispatcher::GetDispatcher()
        {
#ifndef _FEATSTD_OS_INTERNAL_THREAD_NOT_SUPPORTED
            FEATSTD_SYNCED_STATIC_OBJECT(bool, m_startedDispatcher, false);
            FeatStd::AsyncRequestDispatcherWorkerThread &dispatcher = GetDispatcherWorkerThread();
            if (!m_startedDispatcher) {
                m_startedDispatcher = true;

                // Start thread with default priority
                if (!dispatcher.Start()) {
                    m_startedDispatcher = false;
                }
            }
            return &(dispatcher.GetDispatcher());
#else
            return 0;
#endif
        }

        void ThreadingTextRenderDispatcher::WaitForHandleFinished(TextRenderHandle handle)
        {
            bool hasFinished = false;
            do {
                // is also true when handle is rescheduled (See comment on WaitForFinished)
                static_cast<void>(handle->WaitForFinished());
                hasFinished = ((handle->IsCompleted()) ||
                               (handle->GetState() == FeatStd::AsyncRequestBase::Aborted) ||
                               (handle->GetState() == FeatStd::AsyncRequestBase::Invalid));
            } while (!hasFinished);
        }

        ThreadingTextRenderDispatcher& ThreadingTextRenderDispatcher::GetInstance()
        {
            FEATSTD_SYNCED_STATIC_OBJECT(ThreadingTextRenderDispatcher, instance);
            FEATSTD_SYNCED_STATIC_OBJECT(bool, initialized, false);
            if (!initialized) {
                static_cast<void>(instance.GetDispatcher());
                initialized = true;
            }
            return instance;
        }

        bool ThreadingTextRenderDispatcher::SetPriority(FeatStd::Internal::ThreadPriority::Enum priority,
            FeatStd::Internal::Thread::SetPriorityCallback callback)
        {
#ifndef _FEATSTD_OS_INTERNAL_THREAD_NOT_SUPPORTED
            using namespace FeatStd::Internal;

            ThreadPriority::Enum rc = GetDispatcherWorkerThread().SetPriority(priority, callback);
            return ((ThreadPriority::ERROR_RETURN != rc) && (ThreadPriority::NO_PERMISSION_RETURN != rc));
#else
            FEATSTD_UNUSED2(priority, callback);
#endif
        }
    }
}
