//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_TextEngine_AsyncTextRenderDispatcher_h
#define Candera_TextEngine_AsyncTextRenderDispatcher_h

#include <Candera/TextEngine/Async/TextRenderDispatcher.h>

CANDERA_UNIT_TEST_TESTCASE_DECLARATION(TextRenderDispatcherTest, RunAsync)
CANDERA_UNIT_TEST_TESTCASE_DECLARATION(TextNode2DTest, AsyncToSyncWithLayout)
CANDERA_UNIT_TEST_TESTCASE_DECLARATION(TextNode2DTest, AsyncToSyncWithoutLayout)

namespace FeatStd {
    class AsyncRequestDispatcher;
}
namespace Candera {
    namespace TextRendering {

        /** @addtogroup CanderaTextEngine
        *  @{
        */

        /**
        * @brief AsyncTextRenderDispatcher dispatches a text request through the update routine.
        */
        class AsyncTextRenderDispatcher : public TextRenderDispatcher {
        public:
            static AsyncTextRenderDispatcher& GetInstance();

            ~AsyncTextRenderDispatcher();

            /**
            * Does what normally UpdateSystem would do:
            * Triggers the dispatcher to start rendering texts (Amount is based on settings)
            */
            static void DispatchNext();

            /**
            * @return true when no requests are queued otherwise false.
            */
            bool IsDispatcherEmpty();

        protected:
            virtual FeatStd::AsyncRequestDispatcher * GetDispatcher() override;

            virtual void DispatchNextInternal();

            virtual UpdateSystem::Delegate& GetRenderDelegate();

            void AttachDispatcher();

            void DetachDispatcher();

            virtual void WaitForHandleFinished(TextRenderHandle handle) override;
            UpdateSystem::Handle m_updateHandle;

            AsyncTextRenderDispatcher();

            CANDERA_UNIT_TEST_TESTCASE_FRIEND(TextRenderDispatcherTest, RunAsync);
            CANDERA_UNIT_TEST_TESTCASE_FRIEND(TextNode2DTest, AsyncToSyncWithLayout);
            CANDERA_UNIT_TEST_TESTCASE_FRIEND(TextNode2DTest, AsyncToSyncWithoutLayout);
        };

        /** @} */ // end of CanderaTextEngine
    }// namespace TextRendering
}// namespace Candera
#endif // Candera_TextEngine_AsyncTextRenderDispatcher_h
