//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_UPDATECOMPONENT_H
#define CANDERA_UPDATECOMPONENT_H

#include <Candera/EngineBase/Common/CanderaObject.h>
#include <Candera/System/EntityComponentSystem/Component.h>
#include <Candera/System/EntityComponentSystem/ComponentSystem.h>
#include <Candera/System/UpdateSystem/UpdateDelegate.h>
#include <CanderaPlatform/OS/CanderaTypes.h>

namespace Candera {

typedef EntityComponentSystem::Entity UpdateEntity;

/** @addtogroup UpdateSystem
 *  @{
 */

/**
 * @brief  UpdateComponent denotes entities that receive callbacks from the UpdateSystem.
 *         This is achieved by initializing an update component with update delegates, and attaching
 *         the component to the entity that wants to receive the callbacks.
 *
 *         Please see UpdateSystem and UpdateDelegate for further information.
 *         Also see the CGI Studio documentation for a code example.
 */

class UpdateComponent : public EntityComponentSystem::Component<UpdateEntity>
{

public:
    FEATSTD_RTTI_DECLARATION();

    /**
     *  Destructor
     */
    virtual ~UpdateComponent() {}

    /**
     *  Get the priority of the component system.
     *  @return  The priority of the component system.
     */
    Float GetPriority() const { return m_priority; }

private:
    friend class EntityComponentSystem::ComponentSystem<UpdateComponent, UpdateEntity>;
    friend class UpdateSystem;

    /**
     *  Constructor
     */
    UpdateComponent() : m_priority(0.0F) {}

    UpdateDelegate m_fixedUpdate;
    UpdateDelegate m_update;
    UpdateDelegate m_lateUpdate;

    Float m_priority;
};

/** @} */ // end of UpdateSystem

} // namespace Candera

#endif
