//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_PROPERTY_H)
    #define CANDERA_PROPERTY_H

#include <Candera/Environment.h>
#include <Candera/System/Properties/DisposableProperty.h>
#include <Candera/System/Properties/DisposablePropertyEx.h>
#include <Candera/System/Properties/SharedPtrProperty.h>
#include <Candera/System/Properties/SimpleProperty.h>
#include <Candera/System/Properties/SimplePropertyEx.h>
#include <Candera/System/Properties/ObservableSimpleProperty.h>
#include <Candera/System/MetaInfo/DataType.h>

namespace Candera {

    namespace MetaInfo {
        namespace Internal {
            template<typename T> struct DataType <SimpleProperty<T> > {
                template <typename P>
                static bool ConvertToString(const SimpleProperty<T> &val, Char* &buf, UInt buf_size)
                {
                    return Candera::MetaInfo::Internal::DataType<P>::ConvertToString(val.Get(), buf, buf_size);
                }

                template <typename P>
                static bool ConvertFromString(SimpleProperty<T> &val, const Char* buf)
                {
                    P propVal;
                    if (!Candera::MetaInfo::Internal::DataType<P>::ConvertFromString(propVal, buf)) {
                        return false;
                    }
                    val.Set(propVal);
                    return true;
                }
            };


            template<typename T> struct DataType <SimplePropertyEx<T> > {
                template <typename P>
                static bool ConvertToString(const SimplePropertyEx<T> &val, Char* &buf, UInt buf_size)
                {
                    return Candera::MetaInfo::Internal::DataType<P>::ConvertToString(val.Get(), buf, buf_size);
                }

                template <typename P>
                static bool ConvertFromString(SimplePropertyEx<T> &val, const Char* buf)
                {
                    P propVal;
                    if (!Candera::MetaInfo::Internal::DataType<P>::ConvertFromString(propVal, buf)) {
                        return false;
                    }
                    val.Set(propVal);
                    return true;
                }
            };

            template<typename T> struct DataType < ObservableSimpleProperty<T> > {
                template <typename P>
                static bool ConvertToString(const ObservableSimpleProperty<T> &val, Char* &buf, UInt buf_size)
                {
                    return Candera::MetaInfo::Internal::DataType<P>::ConvertToString(val.Get(), buf, buf_size);
                }

                template <typename P>
                static bool ConvertFromString(ObservableSimpleProperty<T> &val, const Char* buf)
                {
                    P propVal;
                    if (!Candera::MetaInfo::Internal::DataType<P>::ConvertFromString(propVal, buf)) {
                        return false;
                    }
                    val.Set(propVal);
                    return true;
                }
            };


            template<> struct DataType <DisposablePropertyEx<const Candera::TChar*> > {
                template <typename P>
                static bool ConvertToString(const DisposablePropertyEx<const Candera::TChar*> &val, Char* &buf, UInt buf_size)
                {
                    return Candera::MetaInfo::Internal::DataType<P>::ConvertToString(val.Get(), buf, buf_size);
                }

                template <typename P>
                static bool ConvertFromString(DisposablePropertyEx<const Candera::TChar*> &val, const Char* buf)
                {
                    if (buf == 0) {
                        val.Set(0, 0);
                        return true;
                    }

                    SizeType strLen = StringPlatform::Length(buf);
                    TChar* dupString = FEATSTD_NEW_ARRAY(TChar, strLen + 1);
                    StringPlatform::Copy(dupString, buf);
                    P propVal;
                    if (!Candera::MetaInfo::Internal::DataType<P>::ConvertFromString(propVal, dupString)) {
                        return false;
                    }
                    val.Set(propVal, MemoryManagement::ArrayDisposer<const TChar*>::Dispose);
                    return true;
                }
            };

            template<typename T> struct DataType <SharedPtrProperty<T> > {
                template <typename P>
                static bool ConvertToString(const SharedPtrProperty<T> &val, Char* &buf, UInt buf_size)
                {
                    Candera::MemoryManagement::SharedPointer<T> propVal(const_cast<T*>(val.Get()));
                    return Candera::MetaInfo::Internal::DataType<P>::ConvertToString(propVal, buf, buf_size);
                }

                template <typename P>
                static bool ConvertFromString(SharedPtrProperty<T> &val, const Char* buf)
                {
                    Candera::MemoryManagement::SharedPointer<T> propVal;
                    if (!Candera::MetaInfo::Internal::DataType<P>::ConvertFromString(propVal, buf)) {
                        return false;
                    }
                    val.Set(propVal);
                    return true;
                }
            };
        }
    }   // namespace MetaInfo
}   // namespace Candera

#endif  // CANDERA_PROPERTY_H
