//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef MonitorPublicIF_H
    #define MonitorPublicIF_H
#include <FeatStd/Util/ConvenienceMacros.h>

#if defined (FEATSTD_MONITOR_ENABLED)
    #include <CanderaMonitor/Monitor.h>
    #include <CanderaMonitor/Util/AnimationTimeController.h>
    #include <FeatStd/Monitor/Communication/CommType.h> 

    #define MONITOR_INITIALIZE(start_in_paused_mode, signalNewFrames, trace) \
        Candera::Monitor::RTMonitor::Initialize(start_in_paused_mode, signalNewFrames, trace)

    #define MONITOR_TRYCONNECT() Candera::Monitor::RTMonitor::TryConnect()

    #define MONITOR_HANDLE_PAUSED() Candera::Monitor::RTMonitor::HandlePaused(1)
    
    #define MONITOR_HANDLE_PAUSED_ID(groupId) Candera::Monitor::RTMonitor::HandlePaused(groupId)

    #define MONITOR_HANDLE_RUNNING() Candera::Monitor::RTMonitor::HandleRunning()

    #define MONITOR_FORCE_PAUSED(groupId) \
        Candera::Monitor::RTMonitor::ForcePaused(FeatStd::PerfMon::groupId, \
        __FILE__, __LINE__)
    #define MONITOR_FORCE_PAUSED_IF(condition, groupId) \
        do \
        { \
            if (condition) { \
                MONITOR_FORCE_PAUSED(groupId); \
            } \
        FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(4127, while (false) accepted) \
        } while (false)

    #define MONITOR_SIGNAL_NEW_FRAME() Candera::Monitor::RTMonitor::SignalNewFrame()

    #define MONITOR_PORT_CONFIGURE(address, port, ...) \
       FeatStd::PerfMon::CommType::Configure(address, port)


    #define MONITOR_REGISTER_ANIMATION_DISPATCHER(dispatcher) \
        Candera::Monitor::AnimationTimeController::RegisterAnimationDispatcher(dispatcher)

    #define MONITOR_DEREGISTER_ANIMATION_DISPATCHER(dispatcher) \
        Candera::Monitor::AnimationTimeController::DeregisterAnimationDispatcher(dispatcher)

    #define MONITOR_UPDATE_WORLD_TIME(dispatcher, time) \
        Candera::Monitor::AnimationTimeController::UpdateWorldTime(dispatcher, time)
#else // !defined FEATSTD_MONITOR_ENABLED

    #define MONITOR_INITIALIZE(start_in_paused_mode, signalNewFrames, trace)
    #define MONITOR_TRYCONNECT()

    #define MONITOR_HANDLE_PAUSED()
    #define MONITOR_HANDLE_PAUSED_ID(groupId)
    #define MONITOR_HANDLE_RUNNING()

    #define MONITOR_FORCE_PAUSED(groupId)
    #define MONITOR_FORCE_PAUSED_IF(condition, groupId)

    #define MONITOR_SIGNAL_NEW_FRAME()


    #define MONITOR_PORT_CONFIGURE(address, port)

    #define MONITOR_REGISTER_ANIMATION_DISPATCHER(dispatcher)
    #define MONITOR_DEREGISTER_ANIMATION_DISPATCHER(dispatcher)
    #define MONITOR_UPDATE_WORLD_TIME(dispatcher, time)
#endif  // FEATSTD_MONITOR_ENABLED

#define MONITOR_TCPIP_CONFIGURE(address, port) \
    FEATSTD_WARNING("WARNING: Use of MONITOR_TCPIP_CONFIGURE is deprecated, use MONITOR_PORT_CONFIGURE instead");\
    MONITOR_PORT_CONFIGURE(address, port)
#endif  // MonitorPublicIF_H

#if defined(FEATSTD_MONITOR_ENABLED) && defined(MONITOR_FRAME_DEBUGGER_ENABLED)
    #define MONITOR_MARKER_BEGIN_FRAME() Candera::Monitor::RTMonitor::BeginFrame()
    #define MONITOR_MARKER_END_FRAME() Candera::Monitor::RTMonitor::EndFrame()

    #define MONITOR_INTERNAL_BATCHED_DRAW_BEGIN(node) Candera::Monitor::RTMonitor::BeginBatchedDrawCall(node)
    #define MONITOR_INTERNAL_BATCHED_DRAW(node) Candera::Monitor::RTMonitor::NodeInBatchedDrawCall(node)
    #define MONITOR_INTERNAL_BATCHED_DRAW_END() Candera::Monitor::RTMonitor::EndBatchedDrawCall()
    #define MONITOR_INTERNAL_CLEAR_3D_BEGIN() Candera::Monitor::RTMonitor::BeginClear3D()
    #define MONITOR_INTERNAL_CLEAR_3D_END() Candera::Monitor::RTMonitor::EndClear3D()
    #define MONITOR_INTERNAL_CLEAR_2D_BEGIN() Candera::Monitor::RTMonitor::BeginClear2D()
    #define MONITOR_INTERNAL_CLEAR_2D_END() Candera::Monitor::RTMonitor::EndClear2D()

#else
    #define MONITOR_MARKER_BEGIN_FRAME()
    #define MONITOR_MARKER_END_FRAME()
    #define MONITOR_INTERNAL_BATCHED_DRAW_BEGIN(node)
    #define MONITOR_INTERNAL_BATCHED_DRAW(node)
    #define MONITOR_INTERNAL_BATCHED_DRAW_END()
    #define MONITOR_INTERNAL_CLEAR_3D_BEGIN()
    #define MONITOR_INTERNAL_CLEAR_3D_END()
    #define MONITOR_INTERNAL_CLEAR_2D_BEGIN()
    #define MONITOR_INTERNAL_CLEAR_2D_END()
#endif

#if defined(FEATSTD_MONITOR_ENABLED) && defined(MONITOR_FRAME_DEBUGGER_ENABLED) && defined(MONITOR_FRAME_DEBUGGER_OPENGL_CAPTURE_ENABLED)
    #define MONITOR_FRAME_DEBUGGER_OPENGL_CALL(function) Candera::Monitor::RTMonitor::ReportOpenGlCall(#function);
#else
    #define MONITOR_FRAME_DEBUGGER_OPENGL_CALL(function)
#endif
