//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TYPECONVERTER_H)
#define CANDERA_TYPECONVERTER_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/Common/Color.h>
#ifdef CANDERA_LAYOUT_ENABLED
#include <Candera/EngineBase/Layout/Margin.h>
#endif
#include <Candera/System/Mathematics/Rectangle.h>
#include <Candera/System/Mathematics/Vector2.h>
#include <Candera/System/Mathematics/Vector3.h>
#include <Candera/System/Mathematics/Vector4.h>

namespace Candera {
/// @addtogroup MetaInfo
/// @{
     template <typename To>
     struct FloatConverter {
         enum { Size = 0 };
     };

     template <typename To>
     struct ScalarFloatConverter {
         static void Get(To& object, const Float* data, const Int* channels) { if ((channels != 0) && (data != 0)) object = static_cast<To>(data[channels[0]]); }
         enum { Size = 1 };
     };

     template <> struct FloatConverter<Int8>: public ScalarFloatConverter<Int8>{};
     template <> struct FloatConverter<UInt8>: public ScalarFloatConverter<UInt8> {} ;
     template <> struct FloatConverter<Int16>: public ScalarFloatConverter<Int16> {} ;
     template <> struct FloatConverter<UInt16>: public ScalarFloatConverter<UInt16> {} ;
     template <> struct FloatConverter<Int32>: public ScalarFloatConverter<Int32> {} ;
     template <> struct FloatConverter<UInt32>: public ScalarFloatConverter<UInt32> {} ;
     template <> struct FloatConverter<Int64>: public ScalarFloatConverter<Int64> {} ;
     template <> struct FloatConverter<UInt64>: public ScalarFloatConverter<UInt64> {} ;
     template <> struct FloatConverter<Float>: public ScalarFloatConverter<Float> {} ;
     template <> struct FloatConverter<Double>: public ScalarFloatConverter<Double> {} ;

     template <> struct FloatConverter<FeatStd::Internal::IntSpecializationReplacement>: public ScalarFloatConverter<Int> {} ;
     template <> struct FloatConverter<FeatStd::Internal::UIntSpecializationReplacement>: public ScalarFloatConverter<UInt> {} ;


     template <> struct FloatConverter<bool> {
         static void Get(bool& object, const Float* data, const Int* channels) { object = ((channels != 0) && (data != 0)) ? (data[channels[0]] > 0.5F) : false; }
         enum { Size = 1 };
     };

     template <typename To, typename ScalarType, Int Count>
     struct MultiFloatConverter {
         static void Get(To& object, const Float* data, const Int* channels) {
             if (0 == channels){
                 for (Int index = 0; index < Count; ++index) {
                     ScalarFloatConverter<ScalarType>::Get(object[static_cast<UInt8>(index)], data, &index);
                 }
             }
             else{
                 for (Int index = 0; index < channels[Count]; ++index) {
                     ScalarFloatConverter<ScalarType>::Get(object[static_cast<UInt8>(channels[index])], data, &index);
                 }
             }
         }
         enum { Size = Count };
     };

     template <> struct FloatConverter<Vector2> : public MultiFloatConverter<Vector2, Float, 2> {} ;
     template <> struct FloatConverter<Vector3> : public MultiFloatConverter<Vector3, Float, 3> {} ;
     template <> struct FloatConverter<Vector4> : public MultiFloatConverter<Vector4, Float, 4> {} ;
     template <> struct FloatConverter<Color> : public MultiFloatConverter<Color, Float, 4> {} ;
     template <> struct FloatConverter<Color::Data> : public MultiFloatConverter<Color::Data, Float, 4>{};
     template <> struct FloatConverter<Rectangle> : public MultiFloatConverter<Rectangle, Float, 4>{};
#ifdef CANDERA_LAYOUT_ENABLED
     template <> struct FloatConverter<Margin> : public MultiFloatConverter<Margin, Int16, 4>{};
#endif
     
     /// @}
}
#endif    // CANDERA_TYPECONVERTER_H
