//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(METAINFO_ANIMATIONPROPERTYSETTERS_H)
#define METAINFO_ANIMATIONPROPERTYSETTERS_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/System/MetaInfo/TypeConverter.h>
#include <Candera/System/MetaInfo/PropertyMetaInfo.h>
#include <CanderaPlatform/OS/MemoryPlatform.h>

namespace Candera {
    template <typename T> class ArrayProperty;
    template <typename T> class SimpleProperty;
    template <typename T> class SimplePropertyEx;
    template <typename T> class ObservableSimpleProperty;

    namespace Internal {
/// @addtogroup AnimationBase
/// @{
    template<typename T>
    class ObjectPropertySetter: public Animation::NamedAnimationPropertySetter {
        typedef Animation::NamedAnimationPropertySetter Base;
        public:
            FEATSTD_RTTI_TEMPLATE_DEFINITION(Candera::Internal::ObjectPropertySetter, Animation::NamedAnimationPropertySetter);
            ObjectPropertySetter(T* object) : m_object(object) { }
            T* GetAnimatedObject() { return m_object; }
        private:
            T* m_object;
    };

    template<Int MaxChannelCount>
    class MultiChannelData
    {
    public:
        MultiChannelData(Int channelCount, const Int* channels) {
            if (channelCount > MaxChannelCount) {
                channelCount = MaxChannelCount;
            }
            m_channels[MaxChannelCount] = channelCount;
            MemoryPlatform::Copy(m_channels, channels, channelCount * sizeof(Int));
        }
        const Int* GetChannels() const { return m_channels; }
    private:
        Int m_channels[MaxChannelCount + 1];
    };

    template <typename BaseHostType, typename ValueType, typename PropertyType, Int Size = FloatConverter<ValueType>::Size>
    class MetaInfoPropertyPropertySetter: public Candera::Internal::ObjectPropertySetter<BaseHostType>
    {
        typedef Candera::Internal::ObjectPropertySetter<BaseHostType> Base;
        public:
            MetaInfoPropertyPropertySetter(BaseHostType* host, PropertyType& property, Int dataSize, const Int* channels, const Char* name) :
                Base(host),
                m_channelData(dataSize, channels),
                m_property(property)
            {
                Base::SetPropertyName(name);
            }

            virtual void Set(const Float* value) {
                ValueType propObj = m_property.Get();
                FloatConverter<ValueType>::Get(propObj, value, m_channelData.GetChannels());
                m_property.Set(propObj);
            }

        private:
            MultiChannelData<Size> m_channelData;
            PropertyType& m_property;

            FEATSTD_MAKE_CLASS_UNCOPYABLE(MetaInfoPropertyPropertySetter);
    };

    template <typename BaseHostType, typename ValueType, Int Size = FloatConverter<ValueType>::Size>
    class MetaInfoValuePropertySetter: public Candera::Internal::ObjectPropertySetter<BaseHostType>
    {
        typedef Candera::Internal::ObjectPropertySetter<BaseHostType> Base;
        public:
            MetaInfoValuePropertySetter(BaseHostType* host, ValueType& value, Int dataSize, const Int* channels, const Char* name) :
                Base(host),
                m_channelData(dataSize, channels),
                m_value(value)
            {
                Base::SetPropertyName(name);
            }

            virtual void Set(const Float* value) {
                FloatConverter<ValueType>::Get(m_value, value, m_channelData.GetChannels());
            }

        private:
            MultiChannelData<Size> m_channelData;
            ValueType& m_value;

            FEATSTD_MAKE_CLASS_UNCOPYABLE(MetaInfoValuePropertySetter);
    };

    template <typename T> struct DAPSFactoryTrait
    {
        typedef T ValueType;
        enum { Size = Candera::FloatConverter<T>::Size };
        enum { HasGetter = 0 };
    };

    template <typename T> struct DAPSFactoryTrait< ArrayProperty<T> >
    {
        typedef T ValueType;
        enum { Size = 0 };
        enum { HasGetter = 1 };
    };

    template <typename T> struct DAPSFactoryTrait< SimpleProperty<T> >
    {
        typedef T ValueType;
        enum { Size = Candera::FloatConverter<T>::Size };
        enum { HasGetter = 1 };
    };

    template <typename T> struct DAPSFactoryTrait< SimplePropertyEx<T> >
    {
        typedef T ValueType;
        enum { Size = Candera::FloatConverter<T>::Size };
        enum { HasGetter = 1 };
    };

    template <typename T> struct DAPSFactoryTrait< ObservableSimpleProperty<T> >
    {
        typedef T ValueType;
        enum { Size = Candera::FloatConverter<T>::Size };
        enum { HasGetter = 1 };
    };

    template<bool animatable, bool getter, typename TBaseHostType> struct DAPSFactoryImpl { };

    template<typename TBaseHostType> struct DAPSFactoryImpl<true, false, TBaseHostType>
    {
        template <typename T> static Animation::AnimationPropertySetter::SharedPointer Create(T& property, TBaseHostType* object, Candera::Int dataSize, Candera::Int* channels, const Char* name)
        {
            typedef MetaInfoValuePropertySetter<TBaseHostType, T> CurrentAnimationPropertySetter;
            return Animation::AnimationPropertySetter::SharedPointer(FEATSTD_NEW(CurrentAnimationPropertySetter)(object, property, dataSize, channels, name));
        }
    };

    template<bool getter, typename TBaseHostType> struct DAPSFactoryImpl<false, getter, TBaseHostType>
    {
        template <typename T> static Animation::AnimationPropertySetter::SharedPointer Create(T&, TBaseHostType*, Candera::Int, Candera::Int*, const Char*)
        {
            return Animation::AnimationPropertySetter::SharedPointer(0);
        }
    };

    template<typename TBaseHostType> struct DAPSFactoryImpl<true, true, TBaseHostType>
    {
        template <typename T> static Animation::AnimationPropertySetter::SharedPointer Create(T& property, TBaseHostType* object, Candera::Int dataSize, Candera::Int* channels, const Char* name)
        {
            typedef MetaInfoPropertyPropertySetter<TBaseHostType, typename DAPSFactoryTrait<T>::ValueType, T> CurrentAnimationPropertySetter;
            return Animation::AnimationPropertySetter::SharedPointer(FEATSTD_NEW(CurrentAnimationPropertySetter)(object, property, dataSize, channels, name));
        }
    };

    template <typename TBaseHostType, typename TPropertyType, Candera::MetaInfo::PropertyMetaInfoBase::UpdateType updateType> struct DAPSFactory
    {
        template <typename T> static Animation::AnimationPropertySetter::SharedPointer Create(T& property, TBaseHostType* object, Candera::Int dataSize, Candera::Int* channels, const Char* name)
        {
            return DAPSFactoryImpl<(DAPSFactoryTrait<T>::Size != 0) && (updateType == MetaInfo::PropertyMetaInfoBase::ContinuousUpdateType), DAPSFactoryTrait<T>::HasGetter == 1, TBaseHostType>::Create(property, object, dataSize, channels, name);
        }
    };

    template<bool animatable, typename TBaseHostType, typename TPropertyType, template<typename> class TPropertySetter> struct IAPSFactoryImpl { };

    template<typename TBaseHostType, typename TPropertyType, template<typename> class TPropertySetter> struct IAPSFactoryImpl<true, TBaseHostType, TPropertyType, TPropertySetter>
    {
        static Animation::AnimationPropertySetter::SharedPointer Create(TBaseHostType* object, Candera::Int dataSize, Candera::Int* channels)
        {
            typedef TPropertySetter<TPropertyType> CurrentAnimationPropertySetter;
            return Animation::AnimationPropertySetter::SharedPointer(FEATSTD_NEW(CurrentAnimationPropertySetter)(object, dataSize, channels));
        }
    };

    template<typename TBaseHostType, typename TPropertyType, template<typename> class TPropertySetter> struct IAPSFactoryImpl<false, TBaseHostType, TPropertyType, TPropertySetter>
    {
        static Animation::AnimationPropertySetter::SharedPointer Create(TBaseHostType* , Candera::Int , Candera::Int* )
        {
            return Animation::AnimationPropertySetter::SharedPointer(0);
        }
    };

    template <typename TBaseHostType, typename TPropertyType, template<typename> class TPropertySetter, MetaInfo::PropertyMetaInfoBase::UpdateType updateType> struct IAPSFactory
    {
        static Animation::AnimationPropertySetter::SharedPointer Create(TBaseHostType* object, Candera::Int dataSize, Candera::Int* channels)
        {
            return IAPSFactoryImpl<(Candera::FloatConverter<TPropertyType>::Size != 0) && (updateType == MetaInfo::PropertyMetaInfoBase::ContinuousUpdateType), TBaseHostType, TPropertyType, TPropertySetter>::Create(object, dataSize, channels);
        }
    };
    /// @}
}}
#endif
