//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_OBJECTMETAINFO_H)
    #define CANDERA_OBJECTMETAINFO_H

#include <Candera/System/MetaInfo/MetaInfoBase.h>

namespace FeatStd {
    namespace MemoryManagement {
        template <typename T>
        class SharedPointer;
    }
}

namespace Candera { namespace MetaInfo {
/// @addtogroup MetaInfo
/// @{

template<typename T>
class PropertyMetaInfo;

/**
    *  WidgetMetaInfo defines the meta information stored for each Widget type
    */
template<typename T, typename P = PropertyMetaInfo<T> >
class ObjectMetaInfo : public MetaInfoBase
{
    public:
        /**
            *  Constructs object with given name.
            *  @param name Name to assign to ObjectMetaInfo object.
            */
        ObjectMetaInfo(const Char *name) : MetaInfoBase(name) { }

        /**
            *  Destructor
            */
        virtual ~ObjectMetaInfo() {}

        /**
            *  Retrieves the meta information object of the given widget property
            *  Properties inherited by the base class are contained in this
            *  lookup.
            *  @param name name of the property
            *  @return pointer to the PropertyMetaInfo object, null if the property does not exist
            */
        virtual P* LookupItem(const Char *name) const = 0;

        /**
            *  retrieve meta information object of the property at given index
            *  Properties inherited by the base class are contained in this
            *  enumeration.
            *  @param idx index of the property
            *  @return pointer to the meta information object
            */
        virtual P* GetItem(Int32 idx) const = 0;

        /**
            *  Gives the number of properties in the widget
            *  The number includes properties inherited by base class widget
            *  @return number of properties in the widget
            */
        virtual Int32 GetItemCount() const = 0;
};

template <typename T>
class ObjectMetaInfo<FeatStd::MemoryManagement::SharedPointer<T> >: public ObjectMetaInfo<T> {
public:
    /**
    *  Constructs object with given name.
    *  @param name Name to assign to ObjectMetaInfo object.
    */
    ObjectMetaInfo(const Char *name) : ObjectMetaInfo<T>::ObjectMetaInfo(name) { }

    /**
     *  Creates a new instance of the corresponding T class.
     *  @return A shared pointer to the created T object.
     */
    virtual FeatStd::MemoryManagement::SharedPointer<T> Create() = 0;
};

template <typename T>
class ObjectMetaInfo<T*, PropertyMetaInfo<T> >: public ObjectMetaInfo<T> {
public:
    /**
    *  Constructs object with given name.
    *  @param name Name to assign to ObjectMetaInfo object.
    */
    ObjectMetaInfo(const Char *name) : ObjectMetaInfo<T>::ObjectMetaInfo(name) { }

    /**
     *  Creates a new instance of the corresponding T class.
     *  @return A shared pointer to the created T object.
     */
    virtual T* Create() = 0;
};

/// @}
}}
#endif
