//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_METAINFOBASE_H)
    #define CANDERA_METAINFOBASE_H

#include <Candera/Environment.h>

namespace Candera { namespace MetaInfo {
/// @addtogroup MetaInfo
/// @{
/**
    *  @brief MetaInfoBase base class
    *  Defines the basic set of attributes common to all meta information types in Candera
    */
class MetaInfoBase
{
    public:
        /**
            *  Constructs MetaInfoBase object with the given name
            *  @param typeName name of the object described by MetaInfo
            */
        MetaInfoBase(const Char *typeName) { m_name = typeName; }
        
        /**
         * Destructor.
         */
        virtual ~MetaInfoBase() {}

        /**
            *  Retrieves the name of the MetaInfoBase object.
            *  @return the name of the MetaInfoBase object
            */
        virtual const Char* GetName() const { return m_name; }

#ifdef CANDERA_META_DESCRIPTION
        /**
            *  Returns a readable representation of the MetaInfoBase object name
            *  This method must not be used outside SceneComposer / Player context
            *  @return human readable name of the MetaInfo object
            */
        virtual const Char* GetReadableName() const { return GetName(); }    // scene composer only

        /**
            *  Returns a description of the the associated object
            *  This method must not be used outside SceneComposer / Player context
            *  @return description of the associated object
            */
        virtual const Char *GetDescription() const { return ""; }            // scene composer only

        /**
            *  Return the category of this property.
            *  Categories can be used to group properties.
            *  @return The category of this property.
            */
        virtual const Char* GetCategory() const { return ""; }            // scene composer only

        /**
            *  Return if the MetaInfoBase object is deprecated.
            *  This method must not be used outside SceneComposer / Player context.
            *  @return If the object is deprecated or not.
            */
        virtual bool IsDeprecated() const { return false; }            // scene composer only
#endif

        /**
            * Retrieve hash value associated with MetaInfo.
            * @return hash value
            */
        virtual UInt32 GetHash() const { return 0; }

    private:
        const Char *m_name;
};

/// @}
}}
#endif
