//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_HASHFUNCTIONS_H
#define CANDERA_HASHFUNCTIONS_H

#include <Candera/Environment.h>

namespace Candera { namespace MetaInfo { namespace Internal {
/// @addtogroup MetaInfo
/// @{
/**
    * FNV-1a hashing implementation.
    * @see http://www.isthe.com/chongo/tech/comp/fnv/#FNV-1a
    */
class Fnv1aHash
{
    public:
        /**
            * Compute hash value for a given string.
            * @param string string to be hashed.
            * @return hash value.
            */
        static UInt32 Hash(const Char* string);

        /**
            * Compute hash value from two precalculated hash values.
            * @param hash1 first hash value.
            * @param hash2 second hash value.
            * @return computed hash value.
            */
        static UInt32 MixHash(UInt32 hash1, UInt32 hash2);

    private:
        static const UInt32 offset_basis = 2166136261UL;
        static const UInt32 FNV_prime = 16777619UL;
};
/// @}
}}}
#endif // CANDERA_HASHFUNCTIONS_H
