//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Vector4.h"
#include <Candera/System/Mathematics/Math.h>
#include <Candera/System/Mathematics/Vector3.h>
#include <Candera/System/Mathematics/Matrix4.h>

namespace Candera {
using namespace Diagnostics;

Vector4::Vector4()
{
    m_data.x = 0.0F;
    m_data.y = 0.0F;
    m_data.z = 0.0F;
    m_data.w = 1.0F;
}

Vector4::Vector4(const Vector4& vector) : m_data(vector.m_data)
{
}

Vector4::Vector4(const Vector3& vector, Float wValue)
{
    m_data.x = vector.GetX();
    m_data.y = vector.GetY();
    m_data.z = vector.GetZ();
    m_data.w = wValue;
}

Vector4::Vector4(Float xValue, Float yValue, Float zValue, Float wValue)
{
    m_data.x = xValue;
    m_data.y = yValue;
    m_data.z = zValue;
    m_data.w = wValue;
}

Vector4 Vector4::GetCrossProduct(const Vector4& vector_a, const Vector4& vector_b) const
{
    Vector4 ret;
    ret.m_data.x = ((m_data.y * ((vector_a.m_data.z * vector_b.m_data.w) - (vector_b.m_data.z * vector_a.m_data.w))) -
                    (m_data.z * ((vector_a.m_data.y * vector_b.m_data.w) - (vector_b.m_data.y * vector_a.m_data.w)))) +
                   (m_data.w * ((vector_a.m_data.y * vector_b.m_data.z) - (vector_b.m_data.y * vector_a.m_data.z)));
    ret.m_data.y = -(((m_data.x * ((vector_a.m_data.z * vector_b.m_data.w) - (vector_b.m_data.z * vector_a.m_data.w))) -
                      (m_data.z * ((vector_a.m_data.x * vector_b.m_data.w) - (vector_b.m_data.x * vector_a.m_data.w)))) +
                     (m_data.w * ((vector_a.m_data.x * vector_b.m_data.z) - (vector_b.m_data.x * vector_a.m_data.z))));
    ret.m_data.z = ((m_data.x * ((vector_a.m_data.y * vector_b.m_data.w) - (vector_b.m_data.y * vector_a.m_data.w))) -
                    (m_data.y * ((vector_a.m_data.x * vector_b.m_data.w) - (vector_b.m_data.x * vector_a.m_data.w)))) +
                   (m_data.w * ((vector_a.m_data.x * vector_b.m_data.y) - (vector_b.m_data.x * vector_a.m_data.y)));
    ret.m_data.w = -(((m_data.x * ((vector_a.m_data.y * vector_b.m_data.z) - (vector_b.m_data.y * vector_a.m_data.z))) -
                      (m_data.y * ((vector_a.m_data.x * vector_b.m_data.z) - (vector_b.m_data.x * vector_a.m_data.z)))) +
                     (m_data.z * ((vector_a.m_data.x * vector_b.m_data.y) - (vector_b.m_data.x * vector_a.m_data.y))));
    return ret;
}

void Vector4::TransformCoordinate(const Matrix4& matrix)
{
    Vector4 in = *this;
    this->SetX( (in.GetX() * matrix.Get(0, 0)) +
                (in.GetY() * matrix.Get(1, 0)) +
                (in.GetZ() * matrix.Get(2, 0)) +
                (in.GetW() * matrix.Get(3, 0)));
    this->SetY( (in.GetX() * matrix.Get(0, 1)) +
                (in.GetY() * matrix.Get(1, 1)) +
                (in.GetZ() * matrix.Get(2, 1)) +
                (in.GetW() * matrix.Get(3, 1)));
    this->SetZ( (in.GetX() * matrix.Get(0, 2)) +
                (in.GetY() * matrix.Get(1, 2)) +
                (in.GetZ() * matrix.Get(2, 2)) +
                (in.GetW() * matrix.Get(3, 2)));
    this->SetW( (in.GetX() * matrix.Get(0, 3)) +
                (in.GetY() * matrix.Get(1, 3)) +
                (in.GetZ() * matrix.Get(2, 3)) +
                (in.GetW() * matrix.Get(3, 3)));
}

Float Vector4::GetLength() const
{
    return Math::SquareRoot((m_data.x * m_data.x) + (m_data.y * m_data.y) + (m_data.z * m_data.z) + (m_data.w * m_data.w));
}
} // namespace Candera
