//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Vector2.h"

namespace Candera {


Float Vector2::GetSquaredLength() const
{
    return (m_data.x * m_data.x) + (m_data.y * m_data.y);
}

Float Vector2::GetDistanceTo(const Vector2& vector) const
{
    return (*this - vector).GetLength();
}

Float Vector2::GetSquaredDistanceTo(const Vector2& vector) const
{
    return (*this - vector).GetSquaredLength();
}

Float Vector2::GetDotProduct(const Vector2& vector) const
{
    return (m_data.x * vector.m_data.x) + (m_data.y * vector.m_data.y);
}

Vector2 Vector2::GetCrossProduct(const Vector2& vector) const
{
    return Vector2(m_data.x * vector.m_data.y, m_data.y * vector.m_data.x);
}

Float Vector2::Normalize()
{
    if ((m_data.x == 0.0F) && (m_data.y == 0.0F)) {
        // Catch exceptional case when vector has no direction, and thus cannot be normalized.
        // Return length of zero to guarantee a robust handling.
        return 0.0F;
    }

    Float length = GetLength();

    //Inverse computation: 1 division + 2 multiplications is faster then 2 divisions
    Float inverse_length = 1.0F / length;
    m_data.x *= inverse_length;
    m_data.y *= inverse_length;

    return length;
}

} // namespace Candera


