//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_VARIANT_H)
#define CANDERA_VARIANT_H

#include <FeatStd/Util/Variant.h>
#include <Candera/System/MetaInfo/BaseInternalMacros.h>
#include <Candera/System/MetaInfo/EnumDataTypeInternal.h>

namespace Candera {
    using FeatStd::Variant;
    namespace VariantValueType {
        using FeatStd::VariantValueType::BoolValue;
        using FeatStd::VariantValueType::FloatValue;
        using FeatStd::VariantValueType::Int32Value;
        using FeatStd::VariantValueType::UInt32Value;
        using FeatStd::VariantValueType::DoubleValue;
        using FeatStd::VariantValueType::Int8Value;
        using FeatStd::VariantValueType::Int16Value;
        using FeatStd::VariantValueType::Int64Value;
        using FeatStd::VariantValueType::UInt8Value;
        using FeatStd::VariantValueType::UInt16Value;
        using FeatStd::VariantValueType::UInt64Value;
        using FeatStd::VariantValueType::StringValue;
    }
}

CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(::FeatStd::VariantValueType::Enum, _Candera_VariantValueType_Enum)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(FloatValue)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Int32Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(UInt32Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(BoolValue)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(DoubleValue)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Int8Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Int16Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Int64Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(UInt8Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(UInt16Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(UInt64Value)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(StringValue)
CANDERA_INTERNAL_ENUM_METAINFO_END()

#endif
