//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MathDataTypes.h"
#include <FeatStd/Util/Variant.h>

namespace Candera {
    namespace MetaInfo {

        bool DataType<Rectangle>::ConvertToString(const Rectangle& rect, Char* buf, UInt bufLen) 
        {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
            Float tab[4] = { rect.GetLeft(), rect.GetTop(), rect.GetWidth(), rect.GetHeight() };
            UInt n = SerializationPlatform::FromBinary(buf, bufLen, ",", tab, tab + 4);
            return n == 4;
        }

        bool DataType<Rectangle>::ConvertFromString(Rectangle& rect, const Char* buf) 
        {
            Float tab[4];
            UInt n = SerializationPlatform::ToBinary(buf, ",", tab, tab + 4);
            rect = Rectangle(tab[0], tab[1], tab[2], tab[3]);
            return n == 4;
        }

        bool DataType<Vector2>::ConvertToString(const Vector2 &val, Char *buf, UInt bufLen)
        {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
            Float tab[2] = { val.GetX(), val.GetY() };
            UInt n = SerializationPlatform::FromBinary(buf, bufLen, ",", tab, tab + 2);
            return n == 2;
        }

        bool DataType<Vector2>::ConvertFromString(Vector2 &val, const Char *buf) 
        {
            Float tab[2];
            UInt n = SerializationPlatform::ToBinary(buf, ",", tab, tab + 2);
            val.SetX(tab[0]);
            val.SetY(tab[1]);
            return n == 2;
        }

        bool DataType<Vector3>::ConvertToString(const Vector3 &val, Char *buf, UInt bufLen) 
        {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
            Float tab[3] = { val.GetX(), val.GetY(), val.GetZ() };
            UInt n = SerializationPlatform::FromBinary(buf, bufLen, ",", tab, tab + 3);
            return n == 3;
        }

        bool DataType<Vector3>::ConvertFromString(Vector3 &val, const Char *buf) 
        {
            Float tab[3];
            UInt n = SerializationPlatform::ToBinary(buf, ",", tab, tab + 3);
            val.SetX(tab[0]);
            val.SetY(tab[1]);
            val.SetZ(tab[2]);
            return n == 3;
        }

        bool DataType<Vector4>::ConvertToString(const Vector4 &val, Char *buf, UInt bufLen)
        {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
                Float tab[4] = { val.GetX(), val.GetY(), val.GetZ(), val.GetW() };
            UInt n = SerializationPlatform::FromBinary(buf, bufLen, ",", tab, tab + 4);
            return n == 4;
        }

        bool DataType<Vector4>::ConvertFromString(Vector4 &val, const Char *buf)
        {
            Float tab[4];
            UInt n = SerializationPlatform::ToBinary(buf, ",", tab, tab + 4);
            val.SetX(tab[0]);
            val.SetY(tab[1]);
            val.SetZ(tab[2]);
            val.SetW(tab[3]);
            return n == 4;
        }

        bool DataType<Variant>::ConvertToString(const Variant &val, Char *buf, UInt bufLen)
        {

            UInt n = 0;
            Int count = 0;
            static_cast<void>(SerializationPlatform::FromBinary(buf, bufLen, val.GetType(), &count));
            if (count >= Int(bufLen)) {
                return false;
            }
            buf[count] = ',';
            switch (val.GetType())
            {
            case VariantValueType::BoolValue:
                n = SerializationPlatform::FromBinary(buf + 2, bufLen - 2, static_cast<Int>(val.GetBool()));
                break;
            case VariantValueType::FloatValue:
                n = SerializationPlatform::FromBinary(buf + 2, bufLen - 2, val.GetFloat());
                break;
            case VariantValueType::Int32Value:
                n = SerializationPlatform::FromBinary(buf + 2, bufLen - 2, static_cast<Int>(val.GetInt32()));
                break;
            case VariantValueType::UInt32Value:
                n = SerializationPlatform::FromBinary(buf + 2, bufLen - 2, static_cast<UInt>(val.GetUInt32()));
                break;
            default:
                FeatStd::String s = val.GetString();
                n = SerializationPlatform::FromBinary(buf + (count + 1), bufLen - (FeatStd::Internal::NumericConversion<UInt>(count) + 1), s.GetCString());
                break;
            }
            return n == 1;
        }

        bool DataType<Variant>::ConvertFromString(Variant &val, const Char *buf)
        {
            const Char *buffer = buf;
            UInt32 uint32Value = 0;
            Int32 int32Value = 0;
            Float floatValue = 0.0F;
            Int count = 0;
            Int type = 0;
            UInt n = SerializationPlatform::ToBinary(buffer, ",", &type, &type + 1, &count);
            if (0 != count) {
                buffer += count;
                switch (type)
                {
                case VariantValueType::BoolValue:
                    n += SerializationPlatform::ToBinary(buffer, int32Value);
                    val = FeatStd::Variant(int32Value != 0);
                    break;
                case VariantValueType::FloatValue:
                    FEATSTD_LINT_NEXT_EXPRESSION(1963, "The plain function of ToBinary(...,float,...) has to be called - and will be selected by default. See ruleset of C++. Therefore, correct behavior.")
                    n += SerializationPlatform::ToBinary(buffer, floatValue);
                    val = FeatStd::Variant(floatValue);
                    break;
                case VariantValueType::Int32Value:
                    n += SerializationPlatform::ToBinary(buffer, int32Value);
                    val = FeatStd::Variant(int32Value);
                    break;
                case VariantValueType::UInt32Value:
                    n += SerializationPlatform::ToBinary(buffer, uint32Value);
                    val = FeatStd::Variant(uint32Value);
                    break;
                default:
                    {
                        UInt8 uint8Value = 0;
                        Int8 int8Value = 0;
                        UInt16 uint16Value = 0;
                        Int16 int16Value = 0;
                        UInt64 uint64Value = 0;
                        Int64 int64Value = 0;
                        Double doubleValue = 0.0;
                        FeatStd::Variant var = FeatStd::Variant(FeatStd::String(buf + count));
                        switch (type) {
                            case VariantValueType::DoubleValue:
                                if (!var.TryGetDouble(doubleValue)) {
                                    return false;
                                }
                                val = FeatStd::Variant(doubleValue);
                                break;
                            case VariantValueType::Int8Value:
                                if (!var.TryGetInt8(int8Value)) {
                                    return false;
                                }
                                val = FeatStd::Variant(int8Value);
                                break;
                            case VariantValueType::Int16Value:
                                if (!var.TryGetInt16(int16Value)) {
                                    return false;
                                }
                                val = FeatStd::Variant(int16Value);
                                break;
                            case VariantValueType::Int64Value:
                                if (!var.TryGetInt64(int64Value)) {
                                    return false;
                                }
                                val = FeatStd::Variant(int64Value);
                                break;
                            case VariantValueType::UInt8Value:
                                if (!var.TryGetUInt8(uint8Value)) {
                                    return false;
                                }
                                val = FeatStd::Variant(uint8Value);
                                break;
                            case VariantValueType::UInt16Value:
                                if (!var.TryGetUInt16(uint16Value)) {
                                    return false;
                                }
                                val = FeatStd::Variant(uint16Value);
                                break;
                            case VariantValueType::UInt64Value:
                                if (!var.TryGetUInt64(uint64Value)) {
                                    return false;
                                }
                                val = FeatStd::Variant(uint64Value);
                                break;
                            case VariantValueType::StringValue:
                                val = var;
                                break;
                            default:
                                return false;
                        }
                        return true;
                    }
                }
            }
            return n == 2;
        }

    }   // namespace MetaInfo
}   // namespace Candera

