//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Util/StaticObject.h>
#include "DefaultCultureManager.h"
//#include <Candera/System/Diagnostics/Debug.h>
#include <Candera/System/GlobalizationBase/Localizer.h>
#include <CanderaPlatform/OS/StringPlatform.h>

namespace Candera {
    namespace Globalization {

/******************************************************************************
 *  GetInstance
 ******************************************************************************/
#ifndef CANDERA_GLOBALIZATION_ENABLED
CultureManager& CultureManager::GetInstance()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(DefaultCultureManager, s_defaultCultureManager);
    return s_defaultCultureManager;
}

static CultureManager& s_forceInitInstance = CultureManager::GetInstance();
#endif

/******************************************************************************
 *  Constructor
 ******************************************************************************/
DefaultCultureManager::DefaultCultureManager()
{
}

/******************************************************************************
 *  Destructor
 ******************************************************************************/
DefaultCultureManager::~DefaultCultureManager()
{
}

bool DefaultCultureManager::SetCurrentCulture(const Char* locale)
{
    Culture::SharedPointer defaultCulture = GetDefaultCulture();

    return ((defaultCulture != 0) && (StringPlatform::CompareStrings(locale, defaultCulture->GetLocale()) == 0));
}

Culture::SharedPointer DefaultCultureManager::GetCurrentCulture() const
{
    return GetDefaultCulture();
}

UInt16 DefaultCultureManager::GetCultureCount() const
{
    return (GetDefaultCulture() == 0) ? 0 : 1;
}

Culture::SharedPointer DefaultCultureManager::GetCulture(UInt16 index) const
{
    return ((GetCultureCount() == 1) && (index == 0)) ? GetDefaultCulture() : Culture::SharedPointer();
}

Culture::SharedPointer DefaultCultureManager::GetCulture(const Char* locale) const
{
    Culture::SharedPointer defaultCulture = GetDefaultCulture();

    if ((defaultCulture == 0) || (StringPlatform::CompareStrings(locale, defaultCulture->GetLocale()) == 0)) {
        return defaultCulture;
    }

    return Culture::SharedPointer();
}

void DefaultCultureManager::SetDefaultCulture(Culture::SharedPointer culture)
{
    if (GetDefaultCulture().GetPointerToSharedInstance() != culture.GetPointerToSharedInstance()) {
        CultureManager::SetDefaultCulture(culture);
        NotifyCultureChangeListeners(culture);
    }
}

    }   // namespace Globalization
}   // namespace Candera
