//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ENTITYCOMPONENTSYSTEM_H)
#define CANDERA_ENTITYCOMPONENTSYSTEM_H

#include <Candera/System/EntityComponentSystem/AbstractComponentSystem.h>
#include <Candera/System/EntityComponentSystem/Component.h>
#include <Candera/System/EntityComponentSystem/ComponentHandle.h>
#include <Candera/System/EntityComponentSystem/ComponentPointer.h>
#include <Candera/System/EntityComponentSystem/ComponentSystem.h>
#include <Candera/System/EntityComponentSystem/Entity.h>
#include <Candera/System/EntityComponentSystem/EntitySystem.h>

/** @addtogroup EntityComponentSystem
 *  @{
 */

/**
 * @brief  Entity Component System
 *         An entity component system is a model to decorate objects (entities) with data (components) at runtime.
 *
 *         Entity
 *         In our approach, an object must be derived from the Entity class, to be able to attach components to it. Entity
 *         does not contain any members, so it does not increase the size of your objects, and it is not immediately aware
 *         about components that are attached to it.
 *
 *         Component
 *         Data that you want to attach to an Entity must be contained within an object derived from the Component class.
 *         If you want to adhere to the Entity Component System programming paradigm, it should contain only data, no logic.
 *         Components are referenced by handles, which can be copied and assigned arbitrarily. Handles can be also be resolved
 *         to pointers using the corresponding ComponentSystem. Component pointers cannot be copied and assigned, only
 *         dereferenced for use. Dangling handles resolve to null pointers. The lifetime of a component can be controlled
 *         explicitly by creating or destroying it. Alternatively, when a component is attached to an entity, its lifetime
 *         is automatically linked to the lifetime of the entity. When the entity is destroyed, all attached components are
 *         destroyed automatically, too.
 *
 *         Component System
 *         There is a 1:1 relationship between a Component type and its Component System. The system serves as a factory
 *         for its components. It has direct access to all components and their attached entities. Component Systems are
 *         registered in, and executed by, the globally accessible EntitySystem. Because a component system has all the
 *         information about the data (components) and the objects (entities) that the data belongs to, it should implement
 *         the logic necessary to perform its intended actions.
 *
 *         Entity System
 *         The EntitySystem is a globally accessible class that executes registered component systems, dispatches events
 *         to them, and keeps track of all components attached to entities. Using the entity system, components can be
 *         retrieved by type for any given entity.
 */

/** @} */ // end of EntityComponentSystem

#endif  // CANDERA_ENTITYCOMPONENTSYSTEM_H
