//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_ENTITYCOMPONENTSYSTEM_COMPONENT_H
#define CANDERA_ENTITYCOMPONENTSYSTEM_COMPONENT_H

namespace Candera {

namespace EntityComponentSystem {

/** @addtogroup EntityComponentSystem
 *  @{
 */

/**
 * @brief  Component is the base class that can be attached to any Entity.
 *         For general information about the Entity Component System see EntityComponentSystem.h
 *
 * @tparam EntityType Type of the Entity derived object this component can be attached to.
 */

template<typename EntityType>
class Component
{
public:
    /**
     *  Destructor
     */
    virtual ~Component() {}

    /**
     *  Returns a pointer to the entity this component is attached to, or 0 if this component
     *  is not attached to an entity.
     *  @return  A pointer to entity this component is attached to, or 0 if this component
     *           is not attached to an entity.
     */
    EntityType* GetEntity() const { return m_entity; }

    /**
     *  Check whether this component is attached to an entity.
     *  @return  True, if this component is attached to an entity. False, otherwise.
     */
    bool IsAttached() const { return (0 != m_entity); }

protected:
    /**
     *  Constructor
     */
    Component() : m_entity(0) {}

private:
    template<typename ComponentType, typename EntityTypeAlt> friend class ComponentSystem; // exclusively sets m_entity
    EntityType* m_entity;
};

/** @} */ // end of EntityComponentSystem

} // namespace EntityComponentSystem

} // namespace Candera

#endif
