//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_Diagnostics_LogRealm_h)
#define Candera_Diagnostics_LogRealm_h

#include <FeatStd/Diagnostics/Log.h>
#ifndef FEATSTD_LOG_ENABLED
    #error LOG mechanism files should not be included
#endif

#include <Candera/Environment.h>

namespace Candera { namespace Diagnostics { namespace LogRealm {
/// @addtogroup DiagnosticsSystem
/// @{

FEATSTD_LINT_NEXT_EXPRESSION(1960, "Pull in FeatStd log realms. Accepted here, as local to the name space.")
using namespace FeatStd::Diagnostics::LogRealm;

//! [CANDERA_LogRealm_Declare]

/// Logging data from Candera/Engine2D
FEATSTD_LOG_DECLARE_REALM(CanderaEngine2D);
/// Logging data from Candera/Engine3D
FEATSTD_LOG_DECLARE_REALM(CanderaEngine3D);
/// Logging data from Candera/EngineBase
FEATSTD_LOG_DECLARE_REALM(CanderaEngineBase);
/// Logging data from Candera Animation Framework
FEATSTD_LOG_DECLARE_REALM(CanderaAnimation);
/// Logging data from Candera/System
FEATSTD_LOG_DECLARE_REALM(CanderaSystem);
/// Logging data from Candera/TextEngine
FEATSTD_LOG_DECLARE_REALM(CanderaTextEngine);
/// Logging data from Candera Transition framework
FEATSTD_LOG_DECLARE_REALM(CanderaTransitions);

/// Logging data from CanderaPlatform/Device
FEATSTD_LOG_DECLARE_REALM(CanderaPlatformDevice);
/// Logging data from CanderaPlatform/OS
FEATSTD_LOG_DECLARE_REALM(CanderaPlatformOs);

/// Logging data from Candera AssetLoader module
FEATSTD_LOG_DECLARE_REALM(CanderaAssetLoader);

/// Logging data from Candera Globalization module
FEATSTD_LOG_DECLARE_REALM(CanderaGlobalization);

/// Logging data from Candera Monitor module
FEATSTD_LOG_DECLARE_REALM(CanderaMonitor);

/// Logging data from CanderaScripting framework
FEATSTD_LOG_DECLARE_REALM(CanderaScripting);

/// Logging data from CanderaBehavior
FEATSTD_LOG_DECLARE_REALM(CanderaBehavior);

//! [CANDERA_LogRealm_Declare]

/// \cond DOXYGEN_IGNORE
void LoggerIterationInitialization();
/// \endcond DOXYGEN_IGNORE

/// @}
}}}
#endif

