//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Util/StaticObject.h>
#include "OverlayLayouter.h"

#include "Candera/EngineBase/Layout/ArabicLayouterPatch.h"

namespace Candera {

    /******************************************************************************
    *  Constructor
    ******************************************************************************/
    OverlayLayouter::OverlayLayouter()
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    OverlayLayouter::~OverlayLayouter()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    OverlayLayouter* OverlayLayouter::GetInstance()
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(OverlayLayouter, s_overlayLayouter);
        return &s_overlayLayouter;
    }

    /******************************************************************************
     *  OnMeasure
     ******************************************************************************/
    Vector2 OverlayLayouter::OnMeasure(const AbstractNodePointer& node, const Vector2& clientArea)
    {
        Float width = 0.0F;
        Float height = 0.0F;
        Vector2 childArea(clientArea);

        AbstractNodePointer child = node.GetFirstChild();
        while (child.IsValid()) {
            Layouter* childLayouter = child.GetLayouter();
            if (childLayouter != 0) {
                childLayouter->Measure(child, childArea);

                Vector2 preferredChildSize = childLayouter->GetClientSize(child);
                if (width < preferredChildSize.GetX()) {
                    width = preferredChildSize.GetX();
                }
                if (height < preferredChildSize.GetY()) {
                    height = preferredChildSize.GetY();
                }

            }

            child = child.GetNextSibling();
        }

        return Vector2(width, height);
    }

    /******************************************************************************
     *  OnArrange
     ******************************************************************************/
    void OverlayLayouter::OnArrange(const AbstractNodePointer& node, const Candera::Rectangle& clientArea)
    {
        Node2D* node2D = node.ToNode2D();
        if (0 == node2D || ArabicLayouterPatch::IsSceneEnabled(*node2D)){
            /** ---- Patched Layout ---- **/
            const Float clientWidth = clientArea.GetWidth();
            const Float clientHeight = clientArea.GetHeight();
            Float actualWidth = 0.0F;
            Float actualHeight = 0.0F;
            AbstractNodePointer child = node.GetFirstChild();
            while (child.IsValid()) {
                Layouter* childLayouter = child.GetLayouter();
                if (childLayouter != 0) {
                    Rectangle childArea(0.0F, 0.0F, clientWidth, clientHeight);
                    childLayouter->Arrange(child, childArea);
                    Vector2 childSize = GetArrangeActualSize();
                    if (actualWidth < childSize.GetX()) {
                        actualWidth = childSize.GetX();
                    }
                    if (actualHeight < childSize.GetY()) {
                        actualHeight = childSize.GetY();
                    }
                }
                child = child.GetNextSibling();
            }
            SetArrangeActualSize(Vector2(actualWidth, actualHeight));
            /** ---- Patched Layout end ---- **/
        }
        else {
            /** ---- Old Layout ---- **/
            const Float clientWidth = clientArea.GetWidth();
            const Float clientHeight = clientArea.GetHeight();

            Node2D* child = node2D->GetFirstChild();
            while (child != 0) {
                Layouter* childLayouter = child->GetLayouter();
                if (childLayouter != 0) {
                    Rectangle childArea(0.0F, 0.0F, clientWidth, clientHeight);
                    childLayouter->Arrange(*child, childArea);
                }

                child = child->GetNextSibling();
            }

            SetNodePosition(node, clientArea.GetPosition());
            /** ---- Old Layout end ---- **/
        }
    }
}   // namespace Candera

